@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Email notification of an autoscale event.
 * @property customEmails the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
 * @property sendToSubscriptionAdministrator a value indicating whether to send email to subscription administrator.
 * @property sendToSubscriptionCoAdministrators a value indicating whether to send email to subscription co-administrators.
 */
public data class EmailNotificationResponse(
    public val customEmails: List<String>? = null,
    public val sendToSubscriptionAdministrator: Boolean? = null,
    public val sendToSubscriptionCoAdministrators: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.EmailNotificationResponse):
            EmailNotificationResponse = EmailNotificationResponse(
            customEmails = javaType.customEmails().map({ args0 -> args0 }),
            sendToSubscriptionAdministrator = javaType.sendToSubscriptionAdministrator().map({ args0 ->
                args0
            }).orElse(null),
            sendToSubscriptionCoAdministrators = javaType.sendToSubscriptionCoAdministrators().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
