@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Definition of ARM tracked top level resource.
 * @property dataCollectionEndpointId The resource ID of the data collection endpoint that this rule can be used with.
 * @property dataFlows The specification of data flows.
 * @property dataSources The specification of data sources.
 * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
 * @property description Description of the data collection rule.
 * @property destinations The specification of destinations.
 * @property etag Resource entity tag (ETag).
 * @property id Fully qualified ID of the resource.
 * @property identity Managed service identity of the resource.
 * @property immutableId The immutable ID of this data collection rule. This property is READ-ONLY.
 * @property kind The kind of the resource.
 * @property location The geo-location where the resource lives.
 * @property metadata Metadata about the resource
 * @property name The name of the resource.
 * @property provisioningState The resource provisioning state.
 * @property streamDeclarations Declaration of custom streams used in this rule.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The type of the resource.
 */
public data class GetDataCollectionRuleResult(
    public val dataCollectionEndpointId: String? = null,
    public val dataFlows: List<DataFlowResponse>? = null,
    public val dataSources: DataCollectionRuleResponseDataSources? = null,
    public val description: String? = null,
    public val destinations: DataCollectionRuleResponseDestinations? = null,
    public val etag: String,
    public val id: String,
    public val identity: DataCollectionRuleResourceResponseIdentity? = null,
    public val immutableId: String,
    public val kind: String? = null,
    public val location: String,
    public val metadata: DataCollectionRuleResponseMetadata,
    public val name: String,
    public val provisioningState: String,
    public val streamDeclarations: Map<String, StreamDeclarationResponse>? = null,
    public val systemData: DataCollectionRuleResourceResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetDataCollectionRuleResult):
            GetDataCollectionRuleResult = GetDataCollectionRuleResult(
            dataCollectionEndpointId = javaType.dataCollectionEndpointId().map({ args0 -> args0 }).orElse(null),
            dataFlows = javaType.dataFlows().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataFlowResponse.Companion.toKotlin(args0)
                })
            }),
            dataSources = javaType.dataSources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResponseDataSources.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinations = javaType.destinations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResponseDestinations.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResourceResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            immutableId = javaType.immutableId(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            metadata = javaType.metadata().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResponseMetadata.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            streamDeclarations = javaType.streamDeclarations().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.insights.kotlin.outputs.StreamDeclarationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResourceResponseSystemData.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
