@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Virtual machine guest diagnostic settings resource.
 * @property guestDiagnosticSettingsName The guest diagnostic settings name.
 * @property id Azure resource Id
 * @property location Resource location
 * @property name Azure resource name
 * @property tags Resource tags
 * @property type Azure resource type
 */
public data class GetGuestDiagnosticsSettingsAssociationResult(
    public val guestDiagnosticSettingsName: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetGuestDiagnosticsSettingsAssociationResult):
            GetGuestDiagnosticsSettingsAssociationResult = GetGuestDiagnosticsSettingsAssociationResult(
            guestDiagnosticSettingsName = javaType.guestDiagnosticSettingsName(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
