@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A ProactiveDetection configuration definition.
 * @property customEmails Custom email addresses for this rule notifications
 * @property enabled A flag that indicates whether this rule is enabled by the user
 * @property id Azure resource Id
 * @property lastUpdatedTime The last time this rule was updated
 * @property location Resource location
 * @property name The rule name
 * @property ruleDefinitions Static definitions of the ProactiveDetection configuration rule (same values for all components).
 * @property sendEmailsToSubscriptionOwners A flag that indicated whether notifications on this rule should be sent to subscription owners
 * @property type Azure resource type
 */
public data class GetProactiveDetectionConfigurationResult(
    public val customEmails: List<String>? = null,
    public val enabled: Boolean? = null,
    public val id: String,
    public val lastUpdatedTime: String,
    public val location: String? = null,
    public val name: String,
    public val ruleDefinitions:
    ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesResponseRuleDefinitions? =
        null,
    public val sendEmailsToSubscriptionOwners: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetProactiveDetectionConfigurationResult):
            GetProactiveDetectionConfigurationResult = GetProactiveDetectionConfigurationResult(
            customEmails = javaType.customEmails().map({ args0 -> args0 }),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastUpdatedTime = javaType.lastUpdatedTime(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            ruleDefinitions = javaType.ruleDefinitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesResponseRuleDefinitions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sendEmailsToSubscriptionOwners = javaType.sendEmailsToSubscriptionOwners().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
