@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Application Insights workbook template definition.
 * @property author Information about the author of the workbook template.
 * @property galleries Workbook galleries supported by the template.
 * @property id Azure resource Id
 * @property localized Key value pair of localized gallery. Each key is the locale code of languages supported by the Azure portal.
 * @property location Resource location
 * @property name Azure resource name.
 * @property priority Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode.
 * @property tags Resource tags
 * @property templateData Valid JSON object containing workbook template payload.
 * @property type Azure resource type
 */
public data class GetWorkbookTemplateResult(
    public val author: String? = null,
    public val galleries: List<WorkbookTemplateGalleryResponse>,
    public val id: String,
    public val localized: Map<String, List<WorkbookTemplateLocalizedGalleryResponse>>? = null,
    public val location: String,
    public val name: String,
    public val priority: Int? = null,
    public val tags: Map<String, String>? = null,
    public val templateData: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetWorkbookTemplateResult):
            GetWorkbookTemplateResult = GetWorkbookTemplateResult(
            author = javaType.author().map({ args0 -> args0 }).orElse(null),
            galleries = javaType.galleries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WorkbookTemplateGalleryResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            localized = javaType.localized().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.WorkbookTemplateLocalizedGalleryResponse.Companion.toKotlin(args0)
                        })
                    }),
                )
            }).toMap(),
            location = javaType.location(),
            name = javaType.name(),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateData = javaType.templateData(),
            type = javaType.type(),
        )
    }
}
