@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * A management event rule condition.
 * @property aggregation How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
 * @property dataSource the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
 * @property odataType specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
 */
public data class ManagementEventRuleConditionResponse(
    public val aggregation: ManagementEventAggregationConditionResponse? = null,
    public val dataSource:
    Either<RuleManagementEventDataSourceResponse, RuleMetricDataSourceResponse>? = null,
    public val odataType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ManagementEventRuleConditionResponse):
            ManagementEventRuleConditionResponse = ManagementEventRuleConditionResponse(
            aggregation = javaType.aggregation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ManagementEventAggregationConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataSource = javaType.dataSource().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleManagementEventDataSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.insights.kotlin.outputs.RuleMetricDataSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
