@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Part of Management Group diagnostic setting. Specifies the settings for a particular log.
 * @property category Name of a Management Group Diagnostic Log category for a resource type this setting is applied to.
 * @property categoryGroup Name of a Management Group Diagnostic Log category group for a resource type this setting is applied to.
 * @property enabled a value indicating whether this log is enabled.
 */
public data class ManagementGroupLogSettingsResponse(
    public val category: String? = null,
    public val categoryGroup: String? = null,
    public val enabled: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ManagementGroupLogSettingsResponse):
            ManagementGroupLogSettingsResponse = ManagementGroupLogSettingsResponse(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            categoryGroup = javaType.categoryGroup().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
        )
    }
}
