@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Suppress

/**
 * A rule that provide the triggers and parameters for the scaling action.
 * @property metricTrigger the trigger that results in a scaling action.
 * @property scaleAction the parameters for the scaling action.
 */
public data class ScaleRuleResponse(
    public val metricTrigger: MetricTriggerResponse,
    public val scaleAction: ScaleActionResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ScaleRuleResponse):
            ScaleRuleResponse = ScaleRuleResponse(
            metricTrigger = javaType.metricTrigger().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.MetricTriggerResponse.Companion.toKotlin(args0)
            }),
            scaleAction = javaType.scaleAction().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.ScaleActionResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
