@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The collection of request properties
 * @property followRedirects Follow redirects for this web test.
 * @property headers List of headers and their values to add to the WebTest call.
 * @property httpVerb Http verb to use for this web test.
 * @property parseDependentRequests Parse Dependent request for this WebTest.
 * @property requestBody Base64 encoded string body to send with this web test.
 * @property requestUrl Url location to test.
 */
public data class WebTestPropertiesResponseRequest(
    public val followRedirects: Boolean? = null,
    public val headers: List<HeaderFieldResponse>? = null,
    public val httpVerb: String? = null,
    public val parseDependentRequests: Boolean? = null,
    public val requestBody: String? = null,
    public val requestUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WebTestPropertiesResponseRequest):
            WebTestPropertiesResponseRequest = WebTestPropertiesResponseRequest(
            followRedirects = javaType.followRedirects().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.HeaderFieldResponse.Companion.toKotlin(args0)
                })
            }),
            httpVerb = javaType.httpVerb().map({ args0 -> args0 }).orElse(null),
            parseDependentRequests = javaType.parseDependentRequests().map({ args0 -> args0 }).orElse(null),
            requestBody = javaType.requestBody().map({ args0 -> args0 }).orElse(null),
            requestUrl = javaType.requestUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
