@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A webhook receiver.
 * @property identifierUri Indicates the identifier uri for aad auth.
 * @property name The name of the webhook receiver. Names must be unique across all receivers within a tenant action group.
 * @property objectId Indicates the webhook app object Id for aad auth.
 * @property serviceUri The URI where webhooks should be sent.
 * @property tenantId Indicates the tenant id for aad auth.
 * @property useAadAuth Indicates whether or not use AAD authentication.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class WebhookReceiverResponse(
    public val identifierUri: String? = null,
    public val name: String,
    public val objectId: String? = null,
    public val serviceUri: String,
    public val tenantId: String? = null,
    public val useAadAuth: Boolean? = null,
    public val useCommonAlertSchema: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WebhookReceiverResponse):
            WebhookReceiverResponse = WebhookReceiverResponse(
            identifierUri = javaType.identifierUri().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            serviceUri = javaType.serviceUri(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            useAadAuth = javaType.useAadAuth().map({ args0 -> args0 }).orElse(null),
            useCommonAlertSchema = javaType.useCommonAlertSchema().map({ args0 -> args0 }).orElse(null),
        )
    }
}
