@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin

import com.pulumi.azurenative.integrationspaces.ApplicationResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A resource under application.
 * Azure REST API version: 2023-11-14-preview.
 * ## Example Usage
 * ### CreateOrUpdateApplicationResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationResource = new AzureNative.IntegrationSpaces.ApplicationResource("applicationResource", new()
 *     {
 *         ApplicationName = "Application1",
 *         ResourceGroupName = "testrg",
 *         ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Web/sites/LogicApp1",
 *         ResourceKind = "LogicApp",
 *         ResourceName = "Resource1",
 *         ResourceType = "Microsoft.Web/sites",
 *         SpaceName = "Space1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/integrationspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := integrationspaces.NewApplicationResource(ctx, "applicationResource", &integrationspaces.ApplicationResourceArgs{
 * 			ApplicationName:   pulumi.String("Application1"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ResourceId:        pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Web/sites/LogicApp1"),
 * 			ResourceKind:      pulumi.String("LogicApp"),
 * 			ResourceName:      pulumi.String("Resource1"),
 * 			ResourceType:      pulumi.String("Microsoft.Web/sites"),
 * 			SpaceName:         pulumi.String("Space1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.integrationspaces.ApplicationResource;
 * import com.pulumi.azurenative.integrationspaces.ApplicationResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationResource = new ApplicationResource("applicationResource", ApplicationResourceArgs.builder()
 *             .applicationName("Application1")
 *             .resourceGroupName("testrg")
 *             .resourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Web/sites/LogicApp1")
 *             .resourceKind("LogicApp")
 *             .resourceName("Resource1")
 *             .resourceType("Microsoft.Web/sites")
 *             .spaceName("Space1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:integrationspaces:ApplicationResource Resource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}/resources/{resourceName}
 * ```
 * @property applicationName The name of the Application
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceId The Arm id of the application resource.
 * @property resourceKind The kind of the application resource.
 * @property resourceName The name of the application resource.
 * @property resourceType The type of the application resource.
 * @property spaceName The name of the space
 */
public data class ApplicationResourceArgs(
    public val applicationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val resourceKind: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val spaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.ApplicationResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.ApplicationResourceArgs =
        com.pulumi.azurenative.integrationspaces.ApplicationResourceArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .resourceKind(resourceKind?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationResourceArgs].
 */
@PulumiTagMarker
public class ApplicationResourceArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var resourceKind: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var spaceName: Output<String>? = null

    /**
     * @param value The name of the Application
     */
    @JvmName("ncvusrryyswgpysk")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("heglavbiumggupcw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Arm id of the application resource.
     */
    @JvmName("xfkdrbuodgosacbb")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The kind of the application resource.
     */
    @JvmName("ttfeoxnknwehckgp")
    public suspend fun resourceKind(`value`: Output<String>) {
        this.resourceKind = value
    }

    /**
     * @param value The name of the application resource.
     */
    @JvmName("mktrcnopyqbqlctj")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The type of the application resource.
     */
    @JvmName("gmfcifcvdwyroqgp")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The name of the space
     */
    @JvmName("brlfdjxuuwgugqvp")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value The name of the Application
     */
    @JvmName("rwrihurtkftwkwnl")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ibtnfiivtsmefois")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Arm id of the application resource.
     */
    @JvmName("mwrsphrexqxygwkw")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The kind of the application resource.
     */
    @JvmName("vrtlvtnhnokignob")
    public suspend fun resourceKind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceKind = mapped
    }

    /**
     * @param value The name of the application resource.
     */
    @JvmName("kjqqikupfuolspim")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The type of the application resource.
     */
    @JvmName("ntkrhdyyiokuakad")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("ngfcktqjjwayches")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    internal fun build(): ApplicationResourceArgs = ApplicationResourceArgs(
        applicationName = applicationName,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        resourceKind = resourceKind,
        resourceName = resourceName,
        resourceType = resourceType,
        spaceName = spaceName,
    )
}
