@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.inputs

import com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessMappingItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of business process mapping.
 * @property logicAppResourceId The logic app resource id.
 * @property operationName The operation name.
 * @property operationType The mapping item operation type of the business process.
 * @property workflowName The workflow name within the logic app.
 */
public data class BusinessProcessMappingItemArgs(
    public val logicAppResourceId: Output<String>? = null,
    public val operationName: Output<String>? = null,
    public val operationType: Output<String>? = null,
    public val workflowName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessMappingItemArgs> {
    override fun toJava():
        com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessMappingItemArgs =
        com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessMappingItemArgs.builder()
            .logicAppResourceId(logicAppResourceId?.applyValue({ args0 -> args0 }))
            .operationName(operationName?.applyValue({ args0 -> args0 }))
            .operationType(operationType?.applyValue({ args0 -> args0 }))
            .workflowName(workflowName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BusinessProcessMappingItemArgs].
 */
@PulumiTagMarker
public class BusinessProcessMappingItemArgsBuilder internal constructor() {
    private var logicAppResourceId: Output<String>? = null

    private var operationName: Output<String>? = null

    private var operationType: Output<String>? = null

    private var workflowName: Output<String>? = null

    /**
     * @param value The logic app resource id.
     */
    @JvmName("shorkemgnkirhbnp")
    public suspend fun logicAppResourceId(`value`: Output<String>) {
        this.logicAppResourceId = value
    }

    /**
     * @param value The operation name.
     */
    @JvmName("utvjflfrpcnssssa")
    public suspend fun operationName(`value`: Output<String>) {
        this.operationName = value
    }

    /**
     * @param value The mapping item operation type of the business process.
     */
    @JvmName("bukcvxrwssowayih")
    public suspend fun operationType(`value`: Output<String>) {
        this.operationType = value
    }

    /**
     * @param value The workflow name within the logic app.
     */
    @JvmName("bagiwtgjknfnjfmq")
    public suspend fun workflowName(`value`: Output<String>) {
        this.workflowName = value
    }

    /**
     * @param value The logic app resource id.
     */
    @JvmName("vjfhwttmpxekdund")
    public suspend fun logicAppResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicAppResourceId = mapped
    }

    /**
     * @param value The operation name.
     */
    @JvmName("qbjpstfgintpyqmw")
    public suspend fun operationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationName = mapped
    }

    /**
     * @param value The mapping item operation type of the business process.
     */
    @JvmName("juggrrsofnyeqeeg")
    public suspend fun operationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value The workflow name within the logic app.
     */
    @JvmName("yxbcsnurjkqikupn")
    public suspend fun workflowName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowName = mapped
    }

    internal fun build(): BusinessProcessMappingItemArgs = BusinessProcessMappingItemArgs(
        logicAppResourceId = logicAppResourceId,
        operationName = operationName,
        operationType = operationType,
        workflowName = workflowName,
    )
}
