@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.inputs

import com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessStageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The properties of business process stage.
 * @property description The description of the business stage.
 * @property properties The properties within the properties of the business process stage.
 * @property stagesBefore The property to keep track of stages before current in the business process stage.
 */
public data class BusinessProcessStageArgs(
    public val description: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val stagesBefore: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessStageArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessStageArgs =
        com.pulumi.azurenative.integrationspaces.inputs.BusinessProcessStageArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .stagesBefore(stagesBefore?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BusinessProcessStageArgs].
 */
@PulumiTagMarker
public class BusinessProcessStageArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var stagesBefore: Output<List<String>>? = null

    /**
     * @param value The description of the business stage.
     */
    @JvmName("iowyjvypbvjxcvaf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The properties within the properties of the business process stage.
     */
    @JvmName("oudqxunlpxthfexj")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value The property to keep track of stages before current in the business process stage.
     */
    @JvmName("bqxbrjyrudrgmnjr")
    public suspend fun stagesBefore(`value`: Output<List<String>>) {
        this.stagesBefore = value
    }

    @JvmName("rkiqbvbnpcbmymtb")
    public suspend fun stagesBefore(vararg values: Output<String>) {
        this.stagesBefore = Output.all(values.asList())
    }

    /**
     * @param values The property to keep track of stages before current in the business process stage.
     */
    @JvmName("dlhdoshxydwxjeya")
    public suspend fun stagesBefore(values: List<Output<String>>) {
        this.stagesBefore = Output.all(values)
    }

    /**
     * @param value The description of the business stage.
     */
    @JvmName("pmyiflnwbdcdgfyn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The properties within the properties of the business process stage.
     */
    @JvmName("hvexmcsbutpgduxn")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The properties within the properties of the business process stage.
     */
    @JvmName("ubfkkilrjsxmekva")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The property to keep track of stages before current in the business process stage.
     */
    @JvmName("lbxtdhwspjfarmjm")
    public suspend fun stagesBefore(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stagesBefore = mapped
    }

    /**
     * @param values The property to keep track of stages before current in the business process stage.
     */
    @JvmName("qhhpqruxprkemjlq")
    public suspend fun stagesBefore(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stagesBefore = mapped
    }

    internal fun build(): BusinessProcessStageArgs = BusinessProcessStageArgs(
        description = description,
        properties = properties,
        stagesBefore = stagesBefore,
    )
}
