@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The tracking event definition.
 * @property operationName The operation name.
 * @property operationType The operation type.
 * @property properties The properties to be collected for event.
 */
public data class TrackingEventDefinitionResponse(
    public val operationName: String? = null,
    public val operationType: String? = null,
    public val properties: Map<String, Any>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.TrackingEventDefinitionResponse):
            TrackingEventDefinitionResponse = TrackingEventDefinitionResponse(
            operationName = javaType.operationName().map({ args0 -> args0 }).orElse(null),
            operationType = javaType.operationType().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
