@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.intune.kotlin

import com.pulumi.azurenative.intune.IntuneFunctions.getAndroidMAMPolicyByNamePlain
import com.pulumi.azurenative.intune.IntuneFunctions.getIoMAMPolicyByNamePlain
import com.pulumi.azurenative.intune.kotlin.inputs.GetAndroidMAMPolicyByNamePlainArgs
import com.pulumi.azurenative.intune.kotlin.inputs.GetAndroidMAMPolicyByNamePlainArgsBuilder
import com.pulumi.azurenative.intune.kotlin.inputs.GetIoMAMPolicyByNamePlainArgs
import com.pulumi.azurenative.intune.kotlin.inputs.GetIoMAMPolicyByNamePlainArgsBuilder
import com.pulumi.azurenative.intune.kotlin.outputs.GetAndroidMAMPolicyByNameResult
import com.pulumi.azurenative.intune.kotlin.outputs.GetIoMAMPolicyByNameResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.intune.kotlin.outputs.GetAndroidMAMPolicyByNameResult.Companion.toKotlin as getAndroidMAMPolicyByNameResultToKotlin
import com.pulumi.azurenative.intune.kotlin.outputs.GetIoMAMPolicyByNameResult.Companion.toKotlin as getIoMAMPolicyByNameResultToKotlin

public object IntuneFunctions {
    /**
     * Returns AndroidMAMPolicy with given name.
     * Azure REST API version: 2015-01-14-preview.
     * Other available API versions: 2015-01-14-privatepreview.
     * @param argument null
     * @return Android Policy entity for Intune MAM.
     */
    public suspend fun getAndroidMAMPolicyByName(argument: GetAndroidMAMPolicyByNamePlainArgs):
        GetAndroidMAMPolicyByNameResult =
        getAndroidMAMPolicyByNameResultToKotlin(getAndroidMAMPolicyByNamePlain(argument.toJava()).await())

    /**
     * @see [getAndroidMAMPolicyByName].
     * @param hostName Location hostName for the tenant
     * @param policyName Unique name for the policy
     * @param select select specific fields in entity.
     * @return Android Policy entity for Intune MAM.
     */
    public suspend fun getAndroidMAMPolicyByName(
        hostName: String,
        policyName: String,
        select: String? = null,
    ): GetAndroidMAMPolicyByNameResult {
        val argument = GetAndroidMAMPolicyByNamePlainArgs(
            hostName = hostName,
            policyName = policyName,
            select = select,
        )
        return getAndroidMAMPolicyByNameResultToKotlin(getAndroidMAMPolicyByNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getAndroidMAMPolicyByName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;intune&#46;kotlin&#46;inputs&#46;GetAndroidMAMPolicyByNamePlainArgs].
     * @return Android Policy entity for Intune MAM.
     */
    public suspend
    fun getAndroidMAMPolicyByName(argument: suspend GetAndroidMAMPolicyByNamePlainArgsBuilder.() -> Unit):
        GetAndroidMAMPolicyByNameResult {
        val builder = GetAndroidMAMPolicyByNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAndroidMAMPolicyByNameResultToKotlin(getAndroidMAMPolicyByNamePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns Intune iOS policies.
     * Azure REST API version: 2015-01-14-preview.
     * Other available API versions: 2015-01-14-privatepreview.
     * @param argument null
     * @return iOS Policy entity for Intune MAM.
     */
    public suspend fun getIoMAMPolicyByName(argument: GetIoMAMPolicyByNamePlainArgs):
        GetIoMAMPolicyByNameResult =
        getIoMAMPolicyByNameResultToKotlin(getIoMAMPolicyByNamePlain(argument.toJava()).await())

    /**
     * @see [getIoMAMPolicyByName].
     * @param hostName Location hostName for the tenant
     * @param policyName Unique name for the policy
     * @param select select specific fields in entity.
     * @return iOS Policy entity for Intune MAM.
     */
    public suspend fun getIoMAMPolicyByName(
        hostName: String,
        policyName: String,
        select: String? = null,
    ): GetIoMAMPolicyByNameResult {
        val argument = GetIoMAMPolicyByNamePlainArgs(
            hostName = hostName,
            policyName = policyName,
            select = select,
        )
        return getIoMAMPolicyByNameResultToKotlin(getIoMAMPolicyByNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getIoMAMPolicyByName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;intune&#46;kotlin&#46;inputs&#46;GetIoMAMPolicyByNamePlainArgs].
     * @return iOS Policy entity for Intune MAM.
     */
    public suspend
    fun getIoMAMPolicyByName(argument: suspend GetIoMAMPolicyByNamePlainArgsBuilder.() -> Unit):
        GetIoMAMPolicyByNameResult {
        val builder = GetIoMAMPolicyByNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIoMAMPolicyByNameResultToKotlin(getIoMAMPolicyByNamePlain(builtArgument.toJava()).await())
    }
}
