@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotfirmwaredefense.kotlin

import com.pulumi.azurenative.iotfirmwaredefense.FirmwareArgs.builder
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.enums.Status
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Firmware definition
 * Azure REST API version: 2023-02-08-preview.
 * ## Example Usage
 * ### Firmware_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firmware = new AzureNative.IoTFirmwareDefense.Firmware("firmware", new()
 *     {
 *         Description = "uz",
 *         FileName = "wresexxulcdsdd",
 *         FileSize = 17,
 *         FirmwareId = "umrkdttp",
 *         Model = "f",
 *         ResourceGroupName = "rgworkspaces-firmwares",
 *         Status = "Pending",
 *         StatusMessages = new[]
 *         {
 *             {
 *                 { "message", "ulvhmhokezathzzauiitu" },
 *             },
 *         },
 *         Vendor = "vycmdhgtmepcptyoubztiuudpkcpd",
 *         Version = "s",
 *         WorkspaceName = "A7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotfirmwaredefense/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotfirmwaredefense.NewFirmware(ctx, "firmware", &iotfirmwaredefense.FirmwareArgs{
 * 			Description:       pulumi.String("uz"),
 * 			FileName:          pulumi.String("wresexxulcdsdd"),
 * 			FileSize:          pulumi.Float64(17),
 * 			FirmwareId:        pulumi.String("umrkdttp"),
 * 			Model:             pulumi.String("f"),
 * 			ResourceGroupName: pulumi.String("rgworkspaces-firmwares"),
 * 			Status:            pulumi.String("Pending"),
 * 			StatusMessages: pulumi.Array{
 * 				pulumi.Any{
 * 					Message: "ulvhmhokezathzzauiitu",
 * 				},
 * 			},
 * 			Vendor:        pulumi.String("vycmdhgtmepcptyoubztiuudpkcpd"),
 * 			Version:       pulumi.String("s"),
 * 			WorkspaceName: pulumi.String("A7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotfirmwaredefense.Firmware;
 * import com.pulumi.azurenative.iotfirmwaredefense.FirmwareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firmware = new Firmware("firmware", FirmwareArgs.builder()
 *             .description("uz")
 *             .fileName("wresexxulcdsdd")
 *             .fileSize(17)
 *             .firmwareId("umrkdttp")
 *             .model("f")
 *             .resourceGroupName("rgworkspaces-firmwares")
 *             .status("Pending")
 *             .statusMessages(Map.of("message", "ulvhmhokezathzzauiitu"))
 *             .vendor("vycmdhgtmepcptyoubztiuudpkcpd")
 *             .version("s")
 *             .workspaceName("A7")
 *             .build());
 *     }
 * }
 * ```
 * ### Firmware_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firmware = new AzureNative.IoTFirmwareDefense.Firmware("firmware", new()
 *     {
 *         FirmwareId = "umrkdttp",
 *         ResourceGroupName = "rgworkspaces-firmwares",
 *         WorkspaceName = "A7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotfirmwaredefense/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotfirmwaredefense.NewFirmware(ctx, "firmware", &iotfirmwaredefense.FirmwareArgs{
 * 			FirmwareId:        pulumi.String("umrkdttp"),
 * 			ResourceGroupName: pulumi.String("rgworkspaces-firmwares"),
 * 			WorkspaceName:     pulumi.String("A7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotfirmwaredefense.Firmware;
 * import com.pulumi.azurenative.iotfirmwaredefense.FirmwareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firmware = new Firmware("firmware", FirmwareArgs.builder()
 *             .firmwareId("umrkdttp")
 *             .resourceGroupName("rgworkspaces-firmwares")
 *             .workspaceName("A7")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotfirmwaredefense:Firmware brmvnojpmxsgckdviynhxhftvcvbw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}
 * ```
 * @property description User-specified description of the firmware.
 * @property fileName File name for a firmware that user uploaded.
 * @property fileSize File size of the uploaded firmware image.
 * @property firmwareId The id of the firmware.
 * @property model Firmware model.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property status The status of firmware scan.
 * @property statusMessages A list of errors or other messages generated during firmware analysis
 * @property vendor Firmware vendor.
 * @property version Firmware version.
 * @property workspaceName The name of the firmware analysis workspace.
 */
public data class FirmwareArgs(
    public val description: Output<String>? = null,
    public val fileName: Output<String>? = null,
    public val fileSize: Output<Double>? = null,
    public val firmwareId: Output<String>? = null,
    public val model: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<Either<String, Status>>? = null,
    public val statusMessages: Output<List<Any>>? = null,
    public val vendor: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotfirmwaredefense.FirmwareArgs> {
    override fun toJava(): com.pulumi.azurenative.iotfirmwaredefense.FirmwareArgs =
        com.pulumi.azurenative.iotfirmwaredefense.FirmwareArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .fileSize(fileSize?.applyValue({ args0 -> args0 }))
            .firmwareId(firmwareId?.applyValue({ args0 -> args0 }))
            .model(model?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .statusMessages(statusMessages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vendor(vendor?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirmwareArgs].
 */
@PulumiTagMarker
public class FirmwareArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var fileName: Output<String>? = null

    private var fileSize: Output<Double>? = null

    private var firmwareId: Output<String>? = null

    private var model: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<Either<String, Status>>? = null

    private var statusMessages: Output<List<Any>>? = null

    private var vendor: Output<String>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value User-specified description of the firmware.
     */
    @JvmName("uptlioopocjdvacc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value File name for a firmware that user uploaded.
     */
    @JvmName("csmaudivvhknsxam")
    public suspend fun fileName(`value`: Output<String>) {
        this.fileName = value
    }

    /**
     * @param value File size of the uploaded firmware image.
     */
    @JvmName("akxppgxwgomalhpq")
    public suspend fun fileSize(`value`: Output<Double>) {
        this.fileSize = value
    }

    /**
     * @param value The id of the firmware.
     */
    @JvmName("wvcswfwxkhqdtsfy")
    public suspend fun firmwareId(`value`: Output<String>) {
        this.firmwareId = value
    }

    /**
     * @param value Firmware model.
     */
    @JvmName("myrsrdmmaesbaoyp")
    public suspend fun model(`value`: Output<String>) {
        this.model = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kgiefqcmjmslfnvd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The status of firmware scan.
     */
    @JvmName("wolrxbffjntddsxu")
    public suspend fun status(`value`: Output<Either<String, Status>>) {
        this.status = value
    }

    /**
     * @param value A list of errors or other messages generated during firmware analysis
     */
    @JvmName("tgsghppiksjxkjlm")
    public suspend fun statusMessages(`value`: Output<List<Any>>) {
        this.statusMessages = value
    }

    @JvmName("xmfcwgcopxjocfry")
    public suspend fun statusMessages(vararg values: Output<Any>) {
        this.statusMessages = Output.all(values.asList())
    }

    /**
     * @param values A list of errors or other messages generated during firmware analysis
     */
    @JvmName("migjpdfhwswpvavr")
    public suspend fun statusMessages(values: List<Output<Any>>) {
        this.statusMessages = Output.all(values)
    }

    /**
     * @param value Firmware vendor.
     */
    @JvmName("tnryaynnfdelvipp")
    public suspend fun vendor(`value`: Output<String>) {
        this.vendor = value
    }

    /**
     * @param value Firmware version.
     */
    @JvmName("kmtkjfhcvidnigxf")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the firmware analysis workspace.
     */
    @JvmName("rhtwcppvsjkoxsco")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value User-specified description of the firmware.
     */
    @JvmName("elfkqwmgyuroiwmc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value File name for a firmware that user uploaded.
     */
    @JvmName("gbxlwiqikysauaeo")
    public suspend fun fileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value File size of the uploaded firmware image.
     */
    @JvmName("bfftxvtqoeotevbk")
    public suspend fun fileSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSize = mapped
    }

    /**
     * @param value The id of the firmware.
     */
    @JvmName("mbbgnsktlkhsrlij")
    public suspend fun firmwareId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firmwareId = mapped
    }

    /**
     * @param value Firmware model.
     */
    @JvmName("ucapqxbgpunreqld")
    public suspend fun model(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tixbqufhgkaaulpu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The status of firmware scan.
     */
    @JvmName("cgqricdjvkxipnao")
    public suspend fun status(`value`: Either<String, Status>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of firmware scan.
     */
    @JvmName("dbxtskkefkkacpqf")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of firmware scan.
     */
    @JvmName("obmksljpypgoydta")
    public fun status(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A list of errors or other messages generated during firmware analysis
     */
    @JvmName("qmnfknvdijkwdksl")
    public suspend fun statusMessages(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusMessages = mapped
    }

    /**
     * @param values A list of errors or other messages generated during firmware analysis
     */
    @JvmName("fllgkmowalmcwjlv")
    public suspend fun statusMessages(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusMessages = mapped
    }

    /**
     * @param value Firmware vendor.
     */
    @JvmName("kjpdsgodfrrfshdn")
    public suspend fun vendor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vendor = mapped
    }

    /**
     * @param value Firmware version.
     */
    @JvmName("ttcascbmdppxafnv")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The name of the firmware analysis workspace.
     */
    @JvmName("jdtfcyuortqqdtrb")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): FirmwareArgs = FirmwareArgs(
        description = description,
        fileName = fileName,
        fileSize = fileSize,
        firmwareId = firmwareId,
        model = model,
        resourceGroupName = resourceGroupName,
        status = status,
        statusMessages = statusMessages,
        vendor = vendor,
        version = version,
        workspaceName = workspaceName,
    )
}
