@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotfirmwaredefense.kotlin

import com.pulumi.azurenative.iotfirmwaredefense.IotfirmwaredefenseFunctions.getFirmwarePlain
import com.pulumi.azurenative.iotfirmwaredefense.IotfirmwaredefenseFunctions.getWorkspacePlain
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.inputs.GetFirmwarePlainArgs
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.inputs.GetFirmwarePlainArgsBuilder
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.outputs.GetFirmwareResult
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.outputs.GetWorkspaceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.outputs.GetFirmwareResult.Companion.toKotlin as getFirmwareResultToKotlin
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin

public object IotfirmwaredefenseFunctions {
    /**
     * Get firmware.
     * Azure REST API version: 2023-02-08-preview.
     * @param argument null
     * @return Firmware definition
     */
    public suspend fun getFirmware(argument: GetFirmwarePlainArgs): GetFirmwareResult =
        getFirmwareResultToKotlin(getFirmwarePlain(argument.toJava()).await())

    /**
     * @see [getFirmware].
     * @param firmwareId The id of the firmware.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the firmware analysis workspace.
     * @return Firmware definition
     */
    public suspend fun getFirmware(
        firmwareId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetFirmwareResult {
        val argument = GetFirmwarePlainArgs(
            firmwareId = firmwareId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getFirmwareResultToKotlin(getFirmwarePlain(argument.toJava()).await())
    }

    /**
     * @see [getFirmware].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotfirmwaredefense&#46;kotlin&#46;inputs&#46;GetFirmwarePlainArgs].
     * @return Firmware definition
     */
    public suspend fun getFirmware(argument: suspend GetFirmwarePlainArgsBuilder.() -> Unit):
        GetFirmwareResult {
        val builder = GetFirmwarePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirmwareResultToKotlin(getFirmwarePlain(builtArgument.toJava()).await())
    }

    /**
     * Get firmware analysis workspace.
     * Azure REST API version: 2023-02-08-preview.
     * @param argument null
     * @return Firmware analysis workspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the firmware analysis workspace.
     * @return Firmware analysis workspace.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String):
        GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotfirmwaredefense&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return Firmware analysis workspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }
}
