@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin

import com.pulumi.azurenative.iotoperationsdataprocessor.PipelineArgs.builder
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.PipelineInputArgs
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.PipelineInputArgsBuilder
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.PipelineStageArgs
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.PipelineStageArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Pipeline resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Pipelines create or update - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipeline = new AzureNative.IoTOperationsDataProcessor.Pipeline("pipeline", new()
 *     {
 *         Description = "vayzklhg",
 *         Enabled = true,
 *         ExtendedLocation = new AzureNative.IoTOperationsDataProcessor.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space",
 *             Type = "CustomLocation",
 *         },
 *         Input = new AzureNative.IoTOperationsDataProcessor.Inputs.PipelineInputArgs
 *         {
 *             Next = new[]
 *             {
 *                 "umnuwjk",
 *             },
 *             Type = "xrnubjkvzajxjzb",
 *         },
 *         InstanceName = "056k5pl8t7761-2--ej25u2l28ttb-22mh79-75-2ch-t8",
 *         Location = "westus",
 *         PipelineName = "j8-8--3",
 *         ResourceGroupName = "rgopenapi",
 *         Stages =
 *         {
 *             { "stageId", new AzureNative.IoTOperationsDataProcessor.Inputs.PipelineStageArgs
 *             {
 *                 Next = new[]
 *                 {
 *                     "gxqgqh",
 *                 },
 *                 Type = "cxqgblrzqniowabexbztempdpkuib",
 *             } },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsdataprocessor/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsdataprocessor.NewPipeline(ctx, "pipeline", &iotoperationsdataprocessor.PipelineArgs{
 * 			Description: pulumi.String("vayzklhg"),
 * 			Enabled:     pulumi.Bool(true),
 * 			ExtendedLocation: &iotoperationsdataprocessor.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Input: &iotoperationsdataprocessor.PipelineInputTypeArgs{
 * 				Next: pulumi.StringArray{
 * 					pulumi.String("umnuwjk"),
 * 				},
 * 				Type: pulumi.String("xrnubjkvzajxjzb"),
 * 			},
 * 			InstanceName:      pulumi.String("056k5pl8t7761-2--ej25u2l28ttb-22mh79-75-2ch-t8"),
 * 			Location:          pulumi.String("westus"),
 * 			PipelineName:      pulumi.String("j8-8--3"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Stages: iotoperationsdataprocessor.PipelineStageMap{
 * 				"stageId": &iotoperationsdataprocessor.PipelineStageArgs{
 * 					Next: pulumi.StringArray{
 * 						pulumi.String("gxqgqh"),
 * 					},
 * 					Type: pulumi.String("cxqgblrzqniowabexbztempdpkuib"),
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.Pipeline;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.PipelineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipeline = new Pipeline("pipeline", PipelineArgs.builder()
 *             .description("vayzklhg")
 *             .enabled(true)
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .input(Map.ofEntries(
 *                 Map.entry("next", "umnuwjk"),
 *                 Map.entry("type", "xrnubjkvzajxjzb")
 *             ))
 *             .instanceName("056k5pl8t7761-2--ej25u2l28ttb-22mh79-75-2ch-t8")
 *             .location("westus")
 *             .pipelineName("j8-8--3")
 *             .resourceGroupName("rgopenapi")
 *             .stages(Map.of("stageId", Map.ofEntries(
 *                 Map.entry("next", "gxqgqh"),
 *                 Map.entry("type", "cxqgblrzqniowabexbztempdpkuib")
 *             )))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsdataprocessor:Pipeline IoTOperationsDataProcessor-pipeline-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsDataProcessor/instances/{instanceName}/pipelines/{pipelineName}
 * ```
 * @property description Detailed description of the Pipeline.
 * @property enabled Flag indicating whether the pipeline should be running or not.
 * @property extendedLocation Edge location of the resource.
 * @property input Information about where to pull input data from.
 * @property instanceName Name of instance.
 * @property location The geo-location where the resource lives
 * @property pipelineName Name of pipeline
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property stages Map of stage ids to stage configurations for all pipeline processing and output stages.
 * @property tags Resource tags.
 */
public data class PipelineArgs(
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val input: Output<PipelineInputArgs>? = null,
    public val instanceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val pipelineName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val stages: Output<Map<String, PipelineStageArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.PipelineArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsdataprocessor.PipelineArgs =
        com.pulumi.azurenative.iotoperationsdataprocessor.PipelineArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .pipelineName(pipelineName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .stages(
                stages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.let({ args0 ->
                                args0.toJava()
                            }),
                        )
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipelineArgs].
 */
@PulumiTagMarker
public class PipelineArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var input: Output<PipelineInputArgs>? = null

    private var instanceName: Output<String>? = null

    private var location: Output<String>? = null

    private var pipelineName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var stages: Output<Map<String, PipelineStageArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Detailed description of the Pipeline.
     */
    @JvmName("kyhrxjbunqudswdy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Flag indicating whether the pipeline should be running or not.
     */
    @JvmName("bwerpkiqrlqswscc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("sxvlhyxxbkjbprat")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Information about where to pull input data from.
     */
    @JvmName("lfeayyesrwqvmamn")
    public suspend fun input(`value`: Output<PipelineInputArgs>) {
        this.input = value
    }

    /**
     * @param value Name of instance.
     */
    @JvmName("usarexbsogeoqyhd")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rrvvrhtibmowxgbj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of pipeline
     */
    @JvmName("jcbiueoapexwtkre")
    public suspend fun pipelineName(`value`: Output<String>) {
        this.pipelineName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ckjccxmcrxvstspg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Map of stage ids to stage configurations for all pipeline processing and output stages.
     */
    @JvmName("xteujxayhokxmefx")
    public suspend fun stages(`value`: Output<Map<String, PipelineStageArgs>>) {
        this.stages = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("augpyagtuubvokre")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Detailed description of the Pipeline.
     */
    @JvmName("xiuutpkpfvbxyuji")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Flag indicating whether the pipeline should be running or not.
     */
    @JvmName("ofhyrnmqcpvjrkwr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("vevtyocotcmulbyd")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Edge location of the resource.
     */
    @JvmName("eolaalacmgrcxxpq")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Information about where to pull input data from.
     */
    @JvmName("qbauchmnfjfgiumq")
    public suspend fun input(`value`: PipelineInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Information about where to pull input data from.
     */
    @JvmName("sskwridfosbwvfkf")
    public suspend fun input(argument: suspend PipelineInputArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Name of instance.
     */
    @JvmName("ibaxiwyermecmxcj")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("uddiatdttkqnknde")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of pipeline
     */
    @JvmName("pwrwxhyjdiobtxbs")
    public suspend fun pipelineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aahxwuhnxwpusmly")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Map of stage ids to stage configurations for all pipeline processing and output stages.
     */
    @JvmName("gctmaunqlxqkjchn")
    public suspend fun stages(`value`: Map<String, PipelineStageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    /**
     * @param argument Map of stage ids to stage configurations for all pipeline processing and output stages.
     */
    @JvmName("aodrtbbdwowlnqkl")
    public suspend fun stages(
        vararg
        argument: Pair<String, suspend PipelineStageArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                PipelineStageArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param values Map of stage ids to stage configurations for all pipeline processing and output stages.
     */
    @JvmName("cvuolffigsiitgip")
    public fun stages(vararg values: Pair<String, PipelineStageArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sqgfcwdnsigwepde")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xcgfijnosojivkyb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PipelineArgs = PipelineArgs(
        description = description,
        enabled = enabled,
        extendedLocation = extendedLocation,
        input = input,
        instanceName = instanceName,
        location = location,
        pipelineName = pipelineName,
        resourceGroupName = resourceGroupName,
        stages = stages,
        tags = tags,
    )
}
