@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs

import com.pulumi.azurenative.iotoperationsdataprocessor.inputs.ExtendedLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Extended location is an extension of Azure locations. They provide a way to use their Azure ARC enabled Kubernetes clusters as target locations for deploying Azure services instances.
 * @property name The name of the extended location.
 * @property type The type of the extended location.
 */
public data class ExtendedLocationArgs(
    public val name: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.inputs.ExtendedLocationArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.ExtendedLocationArgs =
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.ExtendedLocationArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtendedLocationArgs].
 */
@PulumiTagMarker
public class ExtendedLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the extended location.
     */
    @JvmName("eaqywtvbviukaftn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the extended location.
     */
    @JvmName("fiqmeosascirvbwv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the extended location.
     */
    @JvmName("aydmktucduwotkml")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of the extended location.
     */
    @JvmName("vhqkaqmpiyhvueop")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExtendedLocationArgs = ExtendedLocationArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
