@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerAuthenticatorMethodsResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerAuthenticatorMethodsResponse.Companion.toKotlin as brokerAuthenticatorMethodsResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BrokerAuthentication].
 */
@PulumiTagMarker
public class BrokerAuthenticationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BrokerAuthenticationArgs = BrokerAuthenticationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BrokerAuthenticationArgsBuilder.() -> Unit) {
        val builder = BrokerAuthenticationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BrokerAuthentication {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.BrokerAuthentication(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BrokerAuthentication(builtJavaResource)
    }
}

/**
 * MQ broker/authentication resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### BrokerAuthentication_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var brokerAuthentication = new AzureNative.IoTOperationsMQ.BrokerAuthentication("brokerAuthentication", new()
 *     {
 *         AuthenticationMethods = new[]
 *         {
 *             new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodsArgs
 *             {
 *                 Custom = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodCustomArgs
 *                 {
 *                     Auth = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorCustomAuthArgs
 *                     {
 *                         X509 = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorCustomAuthX509Args
 *                         {
 *                             KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCertificatePropertiesArgs
 *                             {
 *                                 Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                                 {
 *                                     Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                     {
 *                                         ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                     },
 *                                     DirectoryId = "eyjniptiykzcgbzok",
 *                                     Name = "lxmwfan",
 *                                 },
 *                                 VaultCaChainSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                                 {
 *                                     Name = "bmectskddmpjxnsogwooexj",
 *                                     Version = "unjfbf",
 *                                 },
 *                                 VaultCert = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                                 {
 *                                     Name = "bmectskddmpjxnsogwooexj",
 *                                     Version = "unjfbf",
 *                                 },
 *                             },
 *                             SecretName = "dordbwjewnqkhfd",
 *                         },
 *                     },
 *                     CaCertConfigMap = "diufihyysdcosgy",
 *                     Endpoint = "yy",
 *                     Headers = null,
 *                 },
 *                 Sat = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodSatArgs
 *                 {
 *                     Audiences = new[]
 *                     {
 *                         "fiyitxutbuuhwtltukyjacads",
 *                     },
 *                 },
 *                 Svid = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodSvidArgs
 *                 {
 *                     AgentSocketPath = "gnyowebmeaj",
 *                     IdentityMaxRetry = 4031184731,
 *                     IdentityWaitRetryMs = 2243705844935085568,
 *                 },
 *                 UsernamePassword = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodUsernamePasswordArgs
 *                 {
 *                     KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretPropertiesArgs
 *                     {
 *                         Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                         {
 *                             Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                             {
 *                                 ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                             },
 *                             DirectoryId = "eyjniptiykzcgbzok",
 *                             Name = "lxmwfan",
 *                         },
 *                         VaultSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                         {
 *                             Name = "bmectskddmpjxnsogwooexj",
 *                             Version = "unjfbf",
 *                         },
 *                     },
 *                     SecretName = "blk",
 *                 },
 *                 X509 = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodX509Args
 *                 {
 *                     Attributes = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodX509AttributesArgs
 *                     {
 *                         KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretPropertiesArgs
 *                         {
 *                             Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                             {
 *                                 Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                 {
 *                                     ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                 },
 *                                 DirectoryId = "eyjniptiykzcgbzok",
 *                                 Name = "lxmwfan",
 *                             },
 *                             VaultSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                             {
 *                                 Name = "bmectskddmpjxnsogwooexj",
 *                                 Version = "unjfbf",
 *                             },
 *                         },
 *                         SecretName = "ybcke",
 *                     },
 *                     TrustedClientCaCertConfigMap = "udidafmnpt",
 *                 },
 *             },
 *         },
 *         AuthenticationName = "lUo-GQ3-95F-1O-",
 *         BrokerName = "87v1GC9557XuP-JLI4-",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         ListenerRef = new[]
 *         {
 *             "dhjpypfjzzmwm",
 *         },
 *         Location = "vtxegvaeqwyupplnm",
 *         MqName = "2S-A2-D9kC946K",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewBrokerAuthentication(ctx, "brokerAuthentication", &iotoperationsmq.BrokerAuthenticationArgs{
 * 			AuthenticationMethods: []iotoperationsmq.BrokerAuthenticatorMethodsArgs{
 * 				{
 * 					Custom: {
 * 						Auth: {
 * 							X509: {
 * 								KeyVault: {
 * 									Vault: {
 * 										Credentials: {
 * 											ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 										},
 * 										DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 										Name:        pulumi.String("lxmwfan"),
 * 									},
 * 									VaultCaChainSecret: {
 * 										Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 										Version: pulumi.String("unjfbf"),
 * 									},
 * 									VaultCert: {
 * 										Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 										Version: pulumi.String("unjfbf"),
 * 									},
 * 								},
 * 								SecretName: pulumi.String("dordbwjewnqkhfd"),
 * 							},
 * 						},
 * 						CaCertConfigMap: pulumi.String("diufihyysdcosgy"),
 * 						Endpoint:        pulumi.String("yy"),
 * 						Headers:         nil,
 * 					},
 * 					Sat: {
 * 						Audiences: pulumi.StringArray{
 * 							pulumi.String("fiyitxutbuuhwtltukyjacads"),
 * 						},
 * 					},
 * 					Svid: {
 * 						AgentSocketPath:     pulumi.String("gnyowebmeaj"),
 * 						IdentityMaxRetry:    pulumi.Float64(4031184731),
 * 						IdentityWaitRetryMs: pulumi.Float64(2243705844935085568),
 * 					},
 * 					UsernamePassword: {
 * 						KeyVault: {
 * 							Vault: {
 * 								Credentials: {
 * 									ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 								},
 * 								DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 								Name:        pulumi.String("lxmwfan"),
 * 							},
 * 							VaultSecret: {
 * 								Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 								Version: pulumi.String("unjfbf"),
 * 							},
 * 						},
 * 						SecretName: pulumi.String("blk"),
 * 					},
 * 					X509: {
 * 						Attributes: {
 * 							KeyVault: {
 * 								Vault: {
 * 									Credentials: {
 * 										ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 									},
 * 									DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 									Name:        pulumi.String("lxmwfan"),
 * 								},
 * 								VaultSecret: {
 * 									Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 									Version: pulumi.String("unjfbf"),
 * 								},
 * 							},
 * 							SecretName: pulumi.String("ybcke"),
 * 						},
 * 						TrustedClientCaCertConfigMap: pulumi.String("udidafmnpt"),
 * 					},
 * 				},
 * 			},
 * 			AuthenticationName: pulumi.String("lUo-GQ3-95F-1O-"),
 * 			BrokerName:         pulumi.String("87v1GC9557XuP-JLI4-"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			ListenerRef: pulumi.StringArray{
 * 				pulumi.String("dhjpypfjzzmwm"),
 * 			},
 * 			Location:          pulumi.String("vtxegvaeqwyupplnm"),
 * 			MqName:            pulumi.String("2S-A2-D9kC946K"),
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerAuthentication;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var brokerAuthentication = new BrokerAuthentication("brokerAuthentication", BrokerAuthenticationArgs.builder()
 *             .authenticationMethods(Map.ofEntries(
 *                 Map.entry("custom", Map.ofEntries(
 *                     Map.entry("auth", Map.of("x509", Map.ofEntries(
 *                         Map.entry("keyVault", Map.ofEntries(
 *                             Map.entry("vault", Map.ofEntries(
 *                                 Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                                 Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                                 Map.entry("name", "lxmwfan")
 *                             )),
 *                             Map.entry("vaultCaChainSecret", Map.ofEntries(
 *                                 Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                 Map.entry("version", "unjfbf")
 *                             )),
 *                             Map.entry("vaultCert", Map.ofEntries(
 *                                 Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                 Map.entry("version", "unjfbf")
 *                             ))
 *                         )),
 *                         Map.entry("secretName", "dordbwjewnqkhfd")
 *                     ))),
 *                     Map.entry("caCertConfigMap", "diufihyysdcosgy"),
 *                     Map.entry("endpoint", "yy"),
 *                     Map.entry("headers", )
 *                 )),
 *                 Map.entry("sat", Map.of("audiences", "fiyitxutbuuhwtltukyjacads")),
 *                 Map.entry("svid", Map.ofEntries(
 *                     Map.entry("agentSocketPath", "gnyowebmeaj"),
 *                     Map.entry("identityMaxRetry", 4031184731),
 *                     Map.entry("identityWaitRetryMs", 2243705844935085568)
 *                 )),
 *                 Map.entry("usernamePassword", Map.ofEntries(
 *                     Map.entry("keyVault", Map.ofEntries(
 *                         Map.entry("vault", Map.ofEntries(
 *                             Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                             Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                             Map.entry("name", "lxmwfan")
 *                         )),
 *                         Map.entry("vaultSecret", Map.ofEntries(
 *                             Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                             Map.entry("version", "unjfbf")
 *                         ))
 *                     )),
 *                     Map.entry("secretName", "blk")
 *                 )),
 *                 Map.entry("x509", Map.ofEntries(
 *                     Map.entry("attributes", Map.ofEntries(
 *                         Map.entry("keyVault", Map.ofEntries(
 *                             Map.entry("vault", Map.ofEntries(
 *                                 Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                                 Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                                 Map.entry("name", "lxmwfan")
 *                             )),
 *                             Map.entry("vaultSecret", Map.ofEntries(
 *                                 Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                 Map.entry("version", "unjfbf")
 *                             ))
 *                         )),
 *                         Map.entry("secretName", "ybcke")
 *                     )),
 *                     Map.entry("trustedClientCaCertConfigMap", "udidafmnpt")
 *                 ))
 *             ))
 *             .authenticationName("lUo-GQ3-95F-1O-")
 *             .brokerName("87v1GC9557XuP-JLI4-")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .listenerRef("dhjpypfjzzmwm")
 *             .location("vtxegvaeqwyupplnm")
 *             .mqName("2S-A2-D9kC946K")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:BrokerAuthentication ktgtbdoqrmk /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/broker/{brokerName}/authentication/{authenticationName}
 * ```
 */
public class BrokerAuthentication internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.BrokerAuthentication,
) : KotlinCustomResource(javaResource, BrokerAuthenticationMapper) {
    /**
     * The list of authentication methods supported by the Authentication Resource. For each array element, NOTE - Enum only authenticator type supported.
     */
    public val authenticationMethods: Output<List<BrokerAuthenticatorMethodsResponse>>
        get() = javaResource.authenticationMethods().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> brokerAuthenticatorMethodsResponseToKotlin(args0) })
            })
        })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The array of listener Resources it supports.
     */
    public val listenerRef: Output<List<String>>
        get() = javaResource.listenerRef().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BrokerAuthenticationMapper : ResourceMapper<BrokerAuthentication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.BrokerAuthentication::class == javaResource::class

    override fun map(javaResource: Resource): BrokerAuthentication = BrokerAuthentication(
        javaResource
            as com.pulumi.azurenative.iotoperationsmq.BrokerAuthentication,
    )
}

/**
 * @see [BrokerAuthentication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BrokerAuthentication].
 */
public suspend fun brokerAuthentication(
    name: String,
    block: suspend BrokerAuthenticationResourceBuilder.() -> Unit,
): BrokerAuthentication {
    val builder = BrokerAuthenticationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BrokerAuthentication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun brokerAuthentication(name: String): BrokerAuthentication {
    val builder = BrokerAuthenticationResourceBuilder()
    builder.name(name)
    return builder.build()
}
