@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.BrokerListenerArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.ServiceType
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.TlsCertMethodArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.TlsCertMethodArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ broker/listener resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### BrokerListener_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var brokerListener = new AzureNative.IoTOperationsMQ.BrokerListener("brokerListener", new()
 *     {
 *         AuthenticationEnabled = true,
 *         AuthorizationEnabled = true,
 *         BrokerName = "HGF6WIy6oHv756MjW0JRLILF",
 *         BrokerRef = "ikuszpfycikq",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         ListenerName = "XGEP",
 *         Location = "dppbdcpstouifyko",
 *         MqName = "Z1-2BCdNY4JO--84",
 *         NodePort = 34375,
 *         Port = 19791,
 *         ResourceGroupName = "rgiotoperationsmq",
 *         ServiceName = "euxa",
 *         ServiceType = "clusterIp",
 *         Tags = null,
 *         Tls = new AzureNative.IoTOperationsMQ.Inputs.TlsCertMethodArgs
 *         {
 *             Automatic = new AzureNative.IoTOperationsMQ.Inputs.AutomaticCertMethodArgs
 *             {
 *                 Duration = "rv",
 *                 IssuerRef = new AzureNative.IoTOperationsMQ.Inputs.CertManagerIssuerRefArgs
 *                 {
 *                     Group = "wxydv",
 *                     Kind = "birgjwuxfjcvyqe",
 *                     Name = "krmdlovyynymtvgffaveker",
 *                 },
 *                 PrivateKey = new AzureNative.IoTOperationsMQ.Inputs.CertManagerPrivateKeyArgs
 *                 {
 *                     Algorithm = "wwewfsddymjefuhxzqybwvay",
 *                     RotationPolicy = "jxmpyvfneckopjiakjtous",
 *                     Size = 63427,
 *                 },
 *                 RenewBefore = "dexxoqqkgyofhkbk",
 *                 San = new AzureNative.IoTOperationsMQ.Inputs.SanForCertArgs
 *                 {
 *                     Dns = new[]
 *                     {
 *                         "nknzptgqgjvbkgzv",
 *                     },
 *                     Ip = new[]
 *                     {
 *                         "jpdkemham",
 *                     },
 *                 },
 *                 SecretName = "hquvygbuueerkspqqktviya",
 *                 SecretNamespace = "aevwndhcnfxitdjykp",
 *             },
 *             KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCertificatePropertiesArgs
 *             {
 *                 Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                 {
 *                     Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                     {
 *                         ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                     },
 *                     DirectoryId = "eyjniptiykzcgbzok",
 *                     Name = "lxmwfan",
 *                 },
 *                 VaultCaChainSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                 {
 *                     Name = "bmectskddmpjxnsogwooexj",
 *                     Version = "unjfbf",
 *                 },
 *                 VaultCert = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                 {
 *                     Name = "bmectskddmpjxnsogwooexj",
 *                     Version = "unjfbf",
 *                 },
 *             },
 *             Manual = new AzureNative.IoTOperationsMQ.Inputs.ManualCertMethodArgs
 *             {
 *                 SecretName = "fezcl",
 *                 SecretNamespace = "ozhayajoooingoczovfusqyilin",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iotoperationsmq.NewBrokerListener(ctx, "brokerListener", &iotoperationsmq.BrokerListenerArgs{
 * AuthenticationEnabled: pulumi.Bool(true),
 * AuthorizationEnabled: pulumi.Bool(true),
 * BrokerName: pulumi.String("HGF6WIy6oHv756MjW0JRLILF"),
 * BrokerRef: pulumi.String("ikuszpfycikq"),
 * ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * Name: pulumi.String("an"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * ListenerName: pulumi.String("XGEP"),
 * Location: pulumi.String("dppbdcpstouifyko"),
 * MqName: pulumi.String("Z1-2BCdNY4JO--84"),
 * NodePort: pulumi.Int(34375),
 * Port: pulumi.Int(19791),
 * ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * ServiceName: pulumi.String("euxa"),
 * ServiceType: pulumi.String("clusterIp"),
 * Tags: nil,
 * Tls: iotoperationsmq.TlsCertMethodResponse{
 * Automatic: interface{}{
 * Duration: pulumi.String("rv"),
 * IssuerRef: &iotoperationsmq.CertManagerIssuerRefArgs{
 * Group: pulumi.String("wxydv"),
 * Kind: pulumi.String("birgjwuxfjcvyqe"),
 * Name: pulumi.String("krmdlovyynymtvgffaveker"),
 * },
 * PrivateKey: &iotoperationsmq.CertManagerPrivateKeyArgs{
 * Algorithm: pulumi.String("wwewfsddymjefuhxzqybwvay"),
 * RotationPolicy: pulumi.String("jxmpyvfneckopjiakjtous"),
 * Size: pulumi.Int(63427),
 * },
 * RenewBefore: pulumi.String("dexxoqqkgyofhkbk"),
 * San: &iotoperationsmq.SanForCertArgs{
 * Dns: pulumi.StringArray{
 * pulumi.String("nknzptgqgjvbkgzv"),
 * },
 * Ip: pulumi.StringArray{
 * pulumi.String("jpdkemham"),
 * },
 * },
 * SecretName: pulumi.String("hquvygbuueerkspqqktviya"),
 * SecretNamespace: pulumi.String("aevwndhcnfxitdjykp"),
 * },
 * KeyVault: interface{}{
 * Vault: interface{}{
 * Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * },
 * DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * Name: pulumi.String("lxmwfan"),
 * },
 * VaultCaChainSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * Name: pulumi.String("bmectskddmpjxnsogwooexj"),
 * Version: pulumi.String("unjfbf"),
 * },
 * VaultCert: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * Name: pulumi.String("bmectskddmpjxnsogwooexj"),
 * Version: pulumi.String("unjfbf"),
 * },
 * },
 * Manual: &iotoperationsmq.ManualCertMethodArgs{
 * SecretName: pulumi.String("fezcl"),
 * SecretNamespace: pulumi.String("ozhayajoooingoczovfusqyilin"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerListener;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerListenerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var brokerListener = new BrokerListener("brokerListener", BrokerListenerArgs.builder()
 *             .authenticationEnabled(true)
 *             .authorizationEnabled(true)
 *             .brokerName("HGF6WIy6oHv756MjW0JRLILF")
 *             .brokerRef("ikuszpfycikq")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .listenerName("XGEP")
 *             .location("dppbdcpstouifyko")
 *             .mqName("Z1-2BCdNY4JO--84")
 *             .nodePort(34375)
 *             .port(19791)
 *             .resourceGroupName("rgiotoperationsmq")
 *             .serviceName("euxa")
 *             .serviceType("clusterIp")
 *             .tags()
 *             .tls(Map.ofEntries(
 *                 Map.entry("automatic", Map.ofEntries(
 *                     Map.entry("duration", "rv"),
 *                     Map.entry("issuerRef", Map.ofEntries(
 *                         Map.entry("group", "wxydv"),
 *                         Map.entry("kind", "birgjwuxfjcvyqe"),
 *                         Map.entry("name", "krmdlovyynymtvgffaveker")
 *                     )),
 *                     Map.entry("privateKey", Map.ofEntries(
 *                         Map.entry("algorithm", "wwewfsddymjefuhxzqybwvay"),
 *                         Map.entry("rotationPolicy", "jxmpyvfneckopjiakjtous"),
 *                         Map.entry("size", 63427)
 *                     )),
 *                     Map.entry("renewBefore", "dexxoqqkgyofhkbk"),
 *                     Map.entry("san", Map.ofEntries(
 *                         Map.entry("dns", "nknzptgqgjvbkgzv"),
 *                         Map.entry("ip", "jpdkemham")
 *                     )),
 *                     Map.entry("secretName", "hquvygbuueerkspqqktviya"),
 *                     Map.entry("secretNamespace", "aevwndhcnfxitdjykp")
 *                 )),
 *                 Map.entry("keyVault", Map.ofEntries(
 *                     Map.entry("vault", Map.ofEntries(
 *                         Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                         Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                         Map.entry("name", "lxmwfan")
 *                     )),
 *                     Map.entry("vaultCaChainSecret", Map.ofEntries(
 *                         Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                         Map.entry("version", "unjfbf")
 *                     )),
 *                     Map.entry("vaultCert", Map.ofEntries(
 *                         Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                         Map.entry("version", "unjfbf")
 *                     ))
 *                 )),
 *                 Map.entry("manual", Map.ofEntries(
 *                     Map.entry("secretName", "fezcl"),
 *                     Map.entry("secretNamespace", "ozhayajoooingoczovfusqyilin")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:BrokerListener ukqwzeflpmangzptkaengwiedlsb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/broker/{brokerName}/listener/{listenerName}
 * ```
 * @property authenticationEnabled The flag for enabling Authentication rules on Listener Port.
 * @property authorizationEnabled The flag for enabling Authorization policies on Listener Port. false - AllowAll, true - Use Authorization resource rules if present.
 * @property brokerName Name of MQ broker resource
 * @property brokerRef The k8s cr/resource reference of mq/broker.
 * @property extendedLocation Extended Location
 * @property listenerName Name of MQ broker/listener resource
 * @property location The geo-location where the resource lives
 * @property mqName Name of MQ resource
 * @property nodePort The node port to use on the Host node.
 * @property port The port to start Listening for connections on.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The service name to expose Listener port on.
 * @property serviceType The Kubernetes Service type to deploy for Listener.
 * @property tags Resource tags.
 * @property tls Defines configuration of a TLS server certificate. NOTE Enum - Only one TLS Cert method is supported
 */
public data class BrokerListenerArgs(
    public val authenticationEnabled: Output<Boolean>? = null,
    public val authorizationEnabled: Output<Boolean>? = null,
    public val brokerName: Output<String>? = null,
    public val brokerRef: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val listenerName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val nodePort: Output<Int>? = null,
    public val port: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val serviceType: Output<Either<String, ServiceType>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tls: Output<TlsCertMethodArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.BrokerListenerArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.BrokerListenerArgs =
        com.pulumi.azurenative.iotoperationsmq.BrokerListenerArgs.builder()
            .authenticationEnabled(authenticationEnabled?.applyValue({ args0 -> args0 }))
            .authorizationEnabled(authorizationEnabled?.applyValue({ args0 -> args0 }))
            .brokerName(brokerName?.applyValue({ args0 -> args0 }))
            .brokerRef(brokerRef?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .listenerName(listenerName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .nodePort(nodePort?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .serviceType(
                serviceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BrokerListenerArgs].
 */
@PulumiTagMarker
public class BrokerListenerArgsBuilder internal constructor() {
    private var authenticationEnabled: Output<Boolean>? = null

    private var authorizationEnabled: Output<Boolean>? = null

    private var brokerName: Output<String>? = null

    private var brokerRef: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var listenerName: Output<String>? = null

    private var location: Output<String>? = null

    private var mqName: Output<String>? = null

    private var nodePort: Output<Int>? = null

    private var port: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var serviceType: Output<Either<String, ServiceType>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tls: Output<TlsCertMethodArgs>? = null

    /**
     * @param value The flag for enabling Authentication rules on Listener Port.
     */
    @JvmName("chvfyucanorhlrwh")
    public suspend fun authenticationEnabled(`value`: Output<Boolean>) {
        this.authenticationEnabled = value
    }

    /**
     * @param value The flag for enabling Authorization policies on Listener Port. false - AllowAll, true - Use Authorization resource rules if present.
     */
    @JvmName("vwpjyalqoipkaqwm")
    public suspend fun authorizationEnabled(`value`: Output<Boolean>) {
        this.authorizationEnabled = value
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("hpwcvldpxtimdluo")
    public suspend fun brokerName(`value`: Output<String>) {
        this.brokerName = value
    }

    /**
     * @param value The k8s cr/resource reference of mq/broker.
     */
    @JvmName("bslagetpbudbuerx")
    public suspend fun brokerRef(`value`: Output<String>) {
        this.brokerRef = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("beubotrbsievatcw")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Name of MQ broker/listener resource
     */
    @JvmName("vwftdxtvcojnxjeu")
    public suspend fun listenerName(`value`: Output<String>) {
        this.listenerName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vojrpjbmsbyduiur")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("kiopgqmdvgubqhgd")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The node port to use on the Host node.
     */
    @JvmName("rnxkimncdrtayonj")
    public suspend fun nodePort(`value`: Output<Int>) {
        this.nodePort = value
    }

    /**
     * @param value The port to start Listening for connections on.
     */
    @JvmName("jmiobvheedeluiae")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qpaiwfwogbpjisqo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The service name to expose Listener port on.
     */
    @JvmName("tsscyfnmskjyfgkn")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The Kubernetes Service type to deploy for Listener.
     */
    @JvmName("uicxdhwguwmjggtx")
    public suspend fun serviceType(`value`: Output<Either<String, ServiceType>>) {
        this.serviceType = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rhwydvmxnyjjifvc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines configuration of a TLS server certificate. NOTE Enum - Only one TLS Cert method is supported
     */
    @JvmName("mnajoshqbdnpttic")
    public suspend fun tls(`value`: Output<TlsCertMethodArgs>) {
        this.tls = value
    }

    /**
     * @param value The flag for enabling Authentication rules on Listener Port.
     */
    @JvmName("wglorijslplsrsib")
    public suspend fun authenticationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationEnabled = mapped
    }

    /**
     * @param value The flag for enabling Authorization policies on Listener Port. false - AllowAll, true - Use Authorization resource rules if present.
     */
    @JvmName("jxtrsygcsqdxspuj")
    public suspend fun authorizationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationEnabled = mapped
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("vcbeslqnpawytkrv")
    public suspend fun brokerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokerName = mapped
    }

    /**
     * @param value The k8s cr/resource reference of mq/broker.
     */
    @JvmName("cyfjgfcpdnbnjiog")
    public suspend fun brokerRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokerRef = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("rncjrqmmgpjdhanq")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("elfqpiwecqbfooer")
    public suspend
    fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Name of MQ broker/listener resource
     */
    @JvmName("ytoohodijanyswjr")
    public suspend fun listenerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hwxhuonmmsvnvxon")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("nckbqrcruwgqujga")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The node port to use on the Host node.
     */
    @JvmName("uixmeqaiinpbfeqh")
    public suspend fun nodePort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodePort = mapped
    }

    /**
     * @param value The port to start Listening for connections on.
     */
    @JvmName("ymntftavcgnogsnm")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nibqwhfeavkxhnma")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The service name to expose Listener port on.
     */
    @JvmName("gxtqlrdwvfjhudtd")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The Kubernetes Service type to deploy for Listener.
     */
    @JvmName("wuymcashpcibbbyc")
    public suspend fun serviceType(`value`: Either<String, ServiceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceType = mapped
    }

    /**
     * @param value The Kubernetes Service type to deploy for Listener.
     */
    @JvmName("ugynrvnhhxhwukdy")
    public fun serviceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceType = mapped
    }

    /**
     * @param value The Kubernetes Service type to deploy for Listener.
     */
    @JvmName("bbqdndiebfedwlir")
    public fun serviceType(`value`: ServiceType) {
        val toBeMapped = Either.ofRight<String, ServiceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceType = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ylcsubbcowxxbtwu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cfpejniovkjgfwce")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Defines configuration of a TLS server certificate. NOTE Enum - Only one TLS Cert method is supported
     */
    @JvmName("kjlnmcubgfstkmtc")
    public suspend fun tls(`value`: TlsCertMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument Defines configuration of a TLS server certificate. NOTE Enum - Only one TLS Cert method is supported
     */
    @JvmName("qkbvhdertahentfp")
    public suspend fun tls(argument: suspend TlsCertMethodArgsBuilder.() -> Unit) {
        val toBeMapped = TlsCertMethodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): BrokerListenerArgs = BrokerListenerArgs(
        authenticationEnabled = authenticationEnabled,
        authorizationEnabled = authorizationEnabled,
        brokerName = brokerName,
        brokerRef = brokerRef,
        extendedLocation = extendedLocation,
        listenerName = listenerName,
        location = location,
        mqName = mqName,
        nodePort = nodePort,
        port = port,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        serviceType = serviceType,
        tags = tags,
        tls = tls,
    )
}
