@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeTargetStorageResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionSpecResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin as containerImageResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeTargetStorageResponse.Companion.toKotlin as dataLakeTargetStorageResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionSpecResponse.Companion.toKotlin as localBrokerConnectionSpecResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse.Companion.toKotlin as nodeTolerationsResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DataLakeConnector].
 */
@PulumiTagMarker
public class DataLakeConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataLakeConnectorArgs = DataLakeConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataLakeConnectorArgsBuilder.() -> Unit) {
        val builder = DataLakeConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataLakeConnector {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.DataLakeConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataLakeConnector(builtJavaResource)
    }
}

/**
 * MQ dataLakeConnector resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### DataLakeConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataLakeConnector = new AzureNative.IoTOperationsMQ.DataLakeConnector("dataLakeConnector", new()
 *     {
 *         DataLakeConnectorName = "87v4D",
 *         DatabaseFormat = "delta",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         Instances = 53467,
 *         LocalBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerAuthenticationMethodsArgs
 *             {
 *                 Kubernetes = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerKubernetesAuthenticationArgs
 *                 {
 *                     SecretPath = "soukzfkouir",
 *                     ServiceAccountTokenName = "suwetviuhmhorhvsidlznnufe",
 *                 },
 *             },
 *             Endpoint = "xc",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "rinkomfeznsfedbmllxlbmmhc",
 *             },
 *         },
 *         Location = "ewguwvlahlu",
 *         LogLevel = "ikicyoalavfmqlodnupfjayxjti",
 *         MqName = "Ox--3e65kYN0731DJ1Qg",
 *         NodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         Protocol = "v3",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *         Target = new AzureNative.IoTOperationsMQ.Inputs.DataLakeTargetStorageArgs
 *         {
 *             DatalakeStorage = new AzureNative.IoTOperationsMQ.Inputs.DataLakeServiceStorageArgs
 *             {
 *                 Authentication = new AzureNative.IoTOperationsMQ.Inputs.DataLakeServiceStorageAuthenticationArgs
 *                 {
 *                     AccessTokenSecretName = "cfaoxjbfbwdldqjbfczvovgooyqkl",
 *                     SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                     {
 *                         Audience = "kjderojhpehosgfcrxxbh",
 *                         ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                     },
 *                 },
 *                 Endpoint = "bddy",
 *             },
 *             FabricOneLake = new AzureNative.IoTOperationsMQ.Inputs.DataLakeFabricStorageArgs
 *             {
 *                 Authentication = new AzureNative.IoTOperationsMQ.Inputs.DataLakeFabricStorageAuthenticationArgs
 *                 {
 *                     SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                     {
 *                         Audience = "kjderojhpehosgfcrxxbh",
 *                         ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                     },
 *                 },
 *                 Endpoint = "S.fabric.microsoft.com",
 *                 FabricPath = "files",
 *                 Guids = new AzureNative.IoTOperationsMQ.Inputs.FabricGuidsArgs
 *                 {
 *                     LakehouseGuid = "grsapopwjnuzbmnxbjnawaae",
 *                     WorkspaceGuid = "iwqfplayvdkdxumpdc",
 *                 },
 *                 Names = new AzureNative.IoTOperationsMQ.Inputs.FabricNamesArgs
 *                 {
 *                     LakehouseName = "iqgqtk",
 *                     WorkspaceName = "fxvlfhfcmlhcbgpopyqfikqsryct",
 *                 },
 *             },
 *             LocalStorage = new AzureNative.IoTOperationsMQ.Inputs.DataLakeLocalStorageArgs
 *             {
 *                 VolumeName = "nmzsioldiwteljpplmftk",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iotoperationsmq.NewDataLakeConnector(ctx, "dataLakeConnector", &iotoperationsmq.DataLakeConnectorArgs{
 * DataLakeConnectorName: pulumi.String("87v4D"),
 * DatabaseFormat: pulumi.String("delta"),
 * ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * Name: pulumi.String("an"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * Image: &iotoperationsmq.ContainerImageArgs{
 * PullPolicy: pulumi.String("imfuzvqxgbdwliqnn"),
 * PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * Repository: pulumi.String("m"),
 * Tag: pulumi.String("jygfdiamhhm"),
 * },
 * Instances: pulumi.Int(53467),
 * LocalBrokerConnection: iotoperationsmq.LocalBrokerConnectionSpecResponse{
 * Authentication: interface{}{
 * Kubernetes: &iotoperationsmq.LocalBrokerKubernetesAuthenticationArgs{
 * SecretPath: pulumi.String("soukzfkouir"),
 * ServiceAccountTokenName: pulumi.String("suwetviuhmhorhvsidlznnufe"),
 * },
 * },
 * Endpoint: pulumi.String("xc"),
 * Tls: &iotoperationsmq.LocalBrokerConnectionTlsArgs{
 * TlsEnabled: pulumi.Bool(true),
 * TrustedCaCertificateConfigMap: pulumi.String("rinkomfeznsfedbmllxlbmmhc"),
 * },
 * },
 * Location: pulumi.String("ewguwvlahlu"),
 * LogLevel: pulumi.String("ikicyoalavfmqlodnupfjayxjti"),
 * MqName: pulumi.String("Ox--3e65kYN0731DJ1Qg"),
 * NodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * Effect: pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * Key: pulumi.String("wbrstdwxgm"),
 * Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * Value: pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * },
 * Protocol: pulumi.String("v3"),
 * ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * Tags: nil,
 * Target: iotoperationsmq.DataLakeTargetStorageResponse{
 * DatalakeStorage: interface{}{
 * Authentication: interface{}{
 * AccessTokenSecretName: pulumi.String("cfaoxjbfbwdldqjbfczvovgooyqkl"),
 * SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * Audience: pulumi.String("kjderojhpehosgfcrxxbh"),
 * ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * },
 * },
 * Endpoint: pulumi.String("bddy"),
 * },
 * FabricOneLake: interface{}{
 * Authentication: interface{}{
 * SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * Audience: pulumi.String("kjderojhpehosgfcrxxbh"),
 * ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * },
 * },
 * Endpoint: pulumi.String("S.fabric.microsoft.com"),
 * FabricPath: pulumi.String("files"),
 * Guids: &iotoperationsmq.FabricGuidsArgs{
 * LakehouseGuid: pulumi.String("grsapopwjnuzbmnxbjnawaae"),
 * WorkspaceGuid: pulumi.String("iwqfplayvdkdxumpdc"),
 * },
 * Names: &iotoperationsmq.FabricNamesArgs{
 * LakehouseName: pulumi.String("iqgqtk"),
 * WorkspaceName: pulumi.String("fxvlfhfcmlhcbgpopyqfikqsryct"),
 * },
 * },
 * LocalStorage: &iotoperationsmq.DataLakeLocalStorageArgs{
 * VolumeName: pulumi.String("nmzsioldiwteljpplmftk"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnector;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataLakeConnector = new DataLakeConnector("dataLakeConnector", DataLakeConnectorArgs.builder()
 *             .dataLakeConnectorName("87v4D")
 *             .databaseFormat("delta")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .image(Map.ofEntries(
 *                 Map.entry("pullPolicy", "imfuzvqxgbdwliqnn"),
 *                 Map.entry("pullSecrets", "klnqimxqsrdwhcqldjvdtsrs"),
 *                 Map.entry("repository", "m"),
 *                 Map.entry("tag", "jygfdiamhhm")
 *             ))
 *             .instances(53467)
 *             .localBrokerConnection(Map.ofEntries(
 *                 Map.entry("authentication", Map.of("kubernetes", Map.ofEntries(
 *                     Map.entry("secretPath", "soukzfkouir"),
 *                     Map.entry("serviceAccountTokenName", "suwetviuhmhorhvsidlznnufe")
 *                 ))),
 *                 Map.entry("endpoint", "xc"),
 *                 Map.entry("tls", Map.ofEntries(
 *                     Map.entry("tlsEnabled", true),
 *                     Map.entry("trustedCaCertificateConfigMap", "rinkomfeznsfedbmllxlbmmhc")
 *                 ))
 *             ))
 *             .location("ewguwvlahlu")
 *             .logLevel("ikicyoalavfmqlodnupfjayxjti")
 *             .mqName("Ox--3e65kYN0731DJ1Qg")
 *             .nodeTolerations(Map.ofEntries(
 *                 Map.entry("effect", "eeswvciblqmmaeesjoflyvxqbz"),
 *                 Map.entry("key", "wbrstdwxgm"),
 *                 Map.entry("operator", "lbegegneekwnyodtzraarivtwhmzep"),
 *                 Map.entry("value", "sfafsjdcezdmkwibxeluukxgl")
 *             ))
 *             .protocol("v3")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .target(Map.ofEntries(
 *                 Map.entry("datalakeStorage", Map.ofEntries(
 *                     Map.entry("authentication", Map.ofEntries(
 *                         Map.entry("accessTokenSecretName", "cfaoxjbfbwdldqjbfczvovgooyqkl"),
 *                         Map.entry("systemAssignedManagedIdentity", Map.ofEntries(
 *                             Map.entry("audience", "kjderojhpehosgfcrxxbh"),
 *                             Map.entry("extensionName", "cyckjqqzspleajbtkniwrfsqygjfhe")
 *                         ))
 *                     )),
 *                     Map.entry("endpoint", "bddy")
 *                 )),
 *                 Map.entry("fabricOneLake", Map.ofEntries(
 *                     Map.entry("authentication", Map.of("systemAssignedManagedIdentity", Map.ofEntries(
 *                         Map.entry("audience", "kjderojhpehosgfcrxxbh"),
 *                         Map.entry("extensionName", "cyckjqqzspleajbtkniwrfsqygjfhe")
 *                     ))),
 *                     Map.entry("endpoint", "S.fabric.microsoft.com"),
 *                     Map.entry("fabricPath", "files"),
 *                     Map.entry("guids", Map.ofEntries(
 *                         Map.entry("lakehouseGuid", "grsapopwjnuzbmnxbjnawaae"),
 *                         Map.entry("workspaceGuid", "iwqfplayvdkdxumpdc")
 *                     )),
 *                     Map.entry("names", Map.ofEntries(
 *                         Map.entry("lakehouseName", "iqgqtk"),
 *                         Map.entry("workspaceName", "fxvlfhfcmlhcbgpopyqfikqsryct")
 *                     ))
 *                 )),
 *                 Map.entry("localStorage", Map.of("volumeName", "nmzsioldiwteljpplmftk"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:DataLakeConnector yduqhtfsalzehud /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/dataLakeConnector/{dataLakeConnectorName}
 * ```
 */
public class DataLakeConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.DataLakeConnector,
) : KotlinCustomResource(javaResource, DataLakeConnectorMapper) {
    /**
     * DataLake database format to use.
     */
    public val databaseFormat: Output<String>
        get() = javaResource.databaseFormat().applyValue({ args0 -> args0 })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The details of DataLakeConnector Docker Image.
     */
    public val image: Output<ContainerImageResponse>
        get() = javaResource.image().applyValue({ args0 ->
            args0.let({ args0 ->
                containerImageResponseToKotlin(args0)
            })
        })

    /**
     * The number of DataLakeConnector pods to spin up.
     */
    public val instances: Output<Int>?
        get() = javaResource.instances().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The details for connecting with Local Broker.
     */
    public val localBrokerConnection: Output<LocalBrokerConnectionSpecResponse>?
        get() = javaResource.localBrokerConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> localBrokerConnectionSpecResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The log level of the DataLake Connector instances.
     */
    public val logLevel: Output<String>?
        get() = javaResource.logLevel().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Node Tolerations for the DataLake Connector pods.
     */
    public val nodeTolerations: Output<NodeTolerationsResponse>?
        get() = javaResource.nodeTolerations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodeTolerationsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The protocol to use for connecting with Brokers.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The protocol to use for connecting with Brokers. NOTE - Enum only storage is supported at at time.
     */
    public val target: Output<DataLakeTargetStorageResponse>
        get() = javaResource.target().applyValue({ args0 ->
            args0.let({ args0 ->
                dataLakeTargetStorageResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataLakeConnectorMapper : ResourceMapper<DataLakeConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.DataLakeConnector::class == javaResource::class

    override fun map(javaResource: Resource): DataLakeConnector = DataLakeConnector(
        javaResource as
            com.pulumi.azurenative.iotoperationsmq.DataLakeConnector,
    )
}

/**
 * @see [DataLakeConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataLakeConnector].
 */
public suspend fun dataLakeConnector(
    name: String,
    block: suspend DataLakeConnectorResourceBuilder.() -> Unit,
): DataLakeConnector {
    val builder = DataLakeConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataLakeConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataLakeConnector(name: String): DataLakeConnector {
    val builder = DataLakeConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
