@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.KafkaRemoteBrokerConnectionSpecArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.KafkaRemoteBrokerConnectionSpecArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.LocalBrokerConnectionSpecArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.LocalBrokerConnectionSpecArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ kafkaConnector resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### KafkaConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kafkaConnector = new AzureNative.IoTOperationsMQ.KafkaConnector("kafkaConnector", new()
 *     {
 *         ClientIdPrefix = "yybbbeowkw",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         Instances = 55252,
 *         KafkaConnection = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerAuthenticationPropertiesArgs
 *             {
 *                 AuthType = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerAuthenticationTypesArgs
 *                 {
 *                     Sasl = new AzureNative.IoTOperationsMQ.Inputs.SaslRemoteBrokerBasicAuthenticationArgs
 *                     {
 *                         SaslType = "plain",
 *                         Token = new AzureNative.IoTOperationsMQ.Inputs.SaslRemoteBrokerBasicAuthenticationTokenArgs
 *                         {
 *                             KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KafkaTokenKeyVaultPropertiesArgs
 *                             {
 *                                 Username = "fb",
 *                                 Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                                 {
 *                                     Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                     {
 *                                         ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                     },
 *                                     DirectoryId = "eyjniptiykzcgbzok",
 *                                     Name = "lxmwfan",
 *                                 },
 *                                 VaultSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                                 {
 *                                     Name = "bmectskddmpjxnsogwooexj",
 *                                     Version = "unjfbf",
 *                                 },
 *                             },
 *                             SecretName = "hxmqokubwldgjdtjv",
 *                         },
 *                     },
 *                     SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                     {
 *                         Audience = "kjderojhpehosgfcrxxbh",
 *                         ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                     },
 *                     X509 = new AzureNative.IoTOperationsMQ.Inputs.KafkaX509AuthenticationArgs
 *                     {
 *                         KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCertificatePropertiesArgs
 *                         {
 *                             Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                             {
 *                                 Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                 {
 *                                     ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                 },
 *                                 DirectoryId = "eyjniptiykzcgbzok",
 *                                 Name = "lxmwfan",
 *                             },
 *                             VaultCaChainSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                             {
 *                                 Name = "bmectskddmpjxnsogwooexj",
 *                                 Version = "unjfbf",
 *                             },
 *                             VaultCert = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                             {
 *                                 Name = "bmectskddmpjxnsogwooexj",
 *                                 Version = "unjfbf",
 *                             },
 *                         },
 *                         SecretName = "jlrjvqyoygynlpsekfbvyrpu",
 *                     },
 *                 },
 *                 Enabled = true,
 *             },
 *             Endpoint = "odxpssuhjkbonjmbhbebfjcah",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "kndjozglnxsgnzxq",
 *             },
 *         },
 *         KafkaConnectorName = "V5--OL8-R",
 *         LocalBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerAuthenticationMethodsArgs
 *             {
 *                 Kubernetes = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerKubernetesAuthenticationArgs
 *                 {
 *                     SecretPath = "soukzfkouir",
 *                     ServiceAccountTokenName = "suwetviuhmhorhvsidlznnufe",
 *                 },
 *             },
 *             Endpoint = "xc",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "rinkomfeznsfedbmllxlbmmhc",
 *             },
 *         },
 *         Location = "mpbupgmqssnb",
 *         LogLevel = "g",
 *         MqName = "s47Lj-S2S-Q-XY",
 *         NodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iotoperationsmq.NewKafkaConnector(ctx, "kafkaConnector", &iotoperationsmq.KafkaConnectorArgs{
 * ClientIdPrefix: pulumi.String("yybbbeowkw"),
 * ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * Name: pulumi.String("an"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * Image: &iotoperationsmq.ContainerImageArgs{
 * PullPolicy: pulumi.String("imfuzvqxgbdwliqnn"),
 * PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * Repository: pulumi.String("m"),
 * Tag: pulumi.String("jygfdiamhhm"),
 * },
 * Instances: pulumi.Int(55252),
 * KafkaConnection: iotoperationsmq.KafkaRemoteBrokerConnectionSpecResponse{
 * Authentication: interface{}{
 * AuthType: interface{}{
 * Sasl: interface{}{
 * SaslType: pulumi.String("plain"),
 * Token: interface{}{
 * KeyVault: interface{}{
 * Username: pulumi.String("fb"),
 * Vault: interface{}{
 * Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * },
 * DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * Name: pulumi.String("lxmwfan"),
 * },
 * VaultSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * Name: pulumi.String("bmectskddmpjxnsogwooexj"),
 * Version: pulumi.String("unjfbf"),
 * },
 * },
 * SecretName: pulumi.String("hxmqokubwldgjdtjv"),
 * },
 * },
 * SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * Audience: pulumi.String("kjderojhpehosgfcrxxbh"),
 * ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * },
 * X509: interface{}{
 * KeyVault: interface{}{
 * Vault: interface{}{
 * Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * },
 * DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * Name: pulumi.String("lxmwfan"),
 * },
 * VaultCaChainSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * Name: pulumi.String("bmectskddmpjxnsogwooexj"),
 * Version: pulumi.String("unjfbf"),
 * },
 * VaultCert: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * Name: pulumi.String("bmectskddmpjxnsogwooexj"),
 * Version: pulumi.String("unjfbf"),
 * },
 * },
 * SecretName: pulumi.String("jlrjvqyoygynlpsekfbvyrpu"),
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * },
 * Endpoint: pulumi.String("odxpssuhjkbonjmbhbebfjcah"),
 * Tls: &iotoperationsmq.KafkaRemoteBrokerConnectionTlsArgs{
 * TlsEnabled: pulumi.Bool(true),
 * TrustedCaCertificateConfigMap: pulumi.String("kndjozglnxsgnzxq"),
 * },
 * },
 * KafkaConnectorName: pulumi.String("V5--OL8-R"),
 * LocalBrokerConnection: iotoperationsmq.LocalBrokerConnectionSpecResponse{
 * Authentication: interface{}{
 * Kubernetes: &iotoperationsmq.LocalBrokerKubernetesAuthenticationArgs{
 * SecretPath: pulumi.String("soukzfkouir"),
 * ServiceAccountTokenName: pulumi.String("suwetviuhmhorhvsidlznnufe"),
 * },
 * },
 * Endpoint: pulumi.String("xc"),
 * Tls: &iotoperationsmq.LocalBrokerConnectionTlsArgs{
 * TlsEnabled: pulumi.Bool(true),
 * TrustedCaCertificateConfigMap: pulumi.String("rinkomfeznsfedbmllxlbmmhc"),
 * },
 * },
 * Location: pulumi.String("mpbupgmqssnb"),
 * LogLevel: pulumi.String("g"),
 * MqName: pulumi.String("s47Lj-S2S-Q-XY"),
 * NodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * Effect: pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * Key: pulumi.String("wbrstdwxgm"),
 * Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * Value: pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * },
 * ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnector;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kafkaConnector = new KafkaConnector("kafkaConnector", KafkaConnectorArgs.builder()
 *             .clientIdPrefix("yybbbeowkw")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .image(Map.ofEntries(
 *                 Map.entry("pullPolicy", "imfuzvqxgbdwliqnn"),
 *                 Map.entry("pullSecrets", "klnqimxqsrdwhcqldjvdtsrs"),
 *                 Map.entry("repository", "m"),
 *                 Map.entry("tag", "jygfdiamhhm")
 *             ))
 *             .instances(55252)
 *             .kafkaConnection(Map.ofEntries(
 *                 Map.entry("authentication", Map.ofEntries(
 *                     Map.entry("authType", Map.ofEntries(
 *                         Map.entry("sasl", Map.ofEntries(
 *                             Map.entry("saslType", "plain"),
 *                             Map.entry("token", Map.ofEntries(
 *                                 Map.entry("keyVault", Map.ofEntries(
 *                                     Map.entry("username", "fb"),
 *                                     Map.entry("vault", Map.ofEntries(
 *                                         Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                                         Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                                         Map.entry("name", "lxmwfan")
 *                                     )),
 *                                     Map.entry("vaultSecret", Map.ofEntries(
 *                                         Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                         Map.entry("version", "unjfbf")
 *                                     ))
 *                                 )),
 *                                 Map.entry("secretName", "hxmqokubwldgjdtjv")
 *                             ))
 *                         )),
 *                         Map.entry("systemAssignedManagedIdentity", Map.ofEntries(
 *                             Map.entry("audience", "kjderojhpehosgfcrxxbh"),
 *                             Map.entry("extensionName", "cyckjqqzspleajbtkniwrfsqygjfhe")
 *                         )),
 *                         Map.entry("x509", Map.ofEntries(
 *                             Map.entry("keyVault", Map.ofEntries(
 *                                 Map.entry("vault", Map.ofEntries(
 *                                     Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                                     Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                                     Map.entry("name", "lxmwfan")
 *                                 )),
 *                                 Map.entry("vaultCaChainSecret", Map.ofEntries(
 *                                     Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                     Map.entry("version", "unjfbf")
 *                                 )),
 *                                 Map.entry("vaultCert", Map.ofEntries(
 *                                     Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                     Map.entry("version", "unjfbf")
 *                                 ))
 *                             )),
 *                             Map.entry("secretName", "jlrjvqyoygynlpsekfbvyrpu")
 *                         ))
 *                     )),
 *                     Map.entry("enabled", true)
 *                 )),
 *                 Map.entry("endpoint", "odxpssuhjkbonjmbhbebfjcah"),
 *                 Map.entry("tls", Map.ofEntries(
 *                     Map.entry("tlsEnabled", true),
 *                     Map.entry("trustedCaCertificateConfigMap", "kndjozglnxsgnzxq")
 *                 ))
 *             ))
 *             .kafkaConnectorName("V5--OL8-R")
 *             .localBrokerConnection(Map.ofEntries(
 *                 Map.entry("authentication", Map.of("kubernetes", Map.ofEntries(
 *                     Map.entry("secretPath", "soukzfkouir"),
 *                     Map.entry("serviceAccountTokenName", "suwetviuhmhorhvsidlznnufe")
 *                 ))),
 *                 Map.entry("endpoint", "xc"),
 *                 Map.entry("tls", Map.ofEntries(
 *                     Map.entry("tlsEnabled", true),
 *                     Map.entry("trustedCaCertificateConfigMap", "rinkomfeznsfedbmllxlbmmhc")
 *                 ))
 *             ))
 *             .location("mpbupgmqssnb")
 *             .logLevel("g")
 *             .mqName("s47Lj-S2S-Q-XY")
 *             .nodeTolerations(Map.ofEntries(
 *                 Map.entry("effect", "eeswvciblqmmaeesjoflyvxqbz"),
 *                 Map.entry("key", "wbrstdwxgm"),
 *                 Map.entry("operator", "lbegegneekwnyodtzraarivtwhmzep"),
 *                 Map.entry("value", "sfafsjdcezdmkwibxeluukxgl")
 *             ))
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:KafkaConnector acntmeqjezkawbphgyprhwv /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/kafkaConnector/{kafkaConnectorName}
 * ```
 * @property clientIdPrefix The client id prefix of the dynamically generated client ids.
 * @property extendedLocation Extended Location
 * @property image The details of KafkaConnector Docker Image.
 * @property instances The number of KafkaConnector pods to spin up.
 * @property kafkaConnection The details for connecting with Remote Kafka Broker.
 * @property kafkaConnectorName Name of MQ kafkaConnector resource
 * @property localBrokerConnection The details for connecting with Local Broker.
 * @property location The geo-location where the resource lives
 * @property logLevel The log level of the Bridge Connector instances.
 * @property mqName Name of MQ resource
 * @property nodeTolerations The Node Tolerations for the Bridge Connector pods.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class KafkaConnectorArgs(
    public val clientIdPrefix: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val image: Output<ContainerImageArgs>? = null,
    public val instances: Output<Int>? = null,
    public val kafkaConnection: Output<KafkaRemoteBrokerConnectionSpecArgs>? = null,
    public val kafkaConnectorName: Output<String>? = null,
    public val localBrokerConnection: Output<LocalBrokerConnectionSpecArgs>? = null,
    public val location: Output<String>? = null,
    public val logLevel: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val nodeTolerations: Output<NodeTolerationsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs =
        com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs.builder()
            .clientIdPrefix(clientIdPrefix?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instances(instances?.applyValue({ args0 -> args0 }))
            .kafkaConnection(kafkaConnection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kafkaConnectorName(kafkaConnectorName?.applyValue({ args0 -> args0 }))
            .localBrokerConnection(
                localBrokerConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .nodeTolerations(nodeTolerations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KafkaConnectorArgs].
 */
@PulumiTagMarker
public class KafkaConnectorArgsBuilder internal constructor() {
    private var clientIdPrefix: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var image: Output<ContainerImageArgs>? = null

    private var instances: Output<Int>? = null

    private var kafkaConnection: Output<KafkaRemoteBrokerConnectionSpecArgs>? = null

    private var kafkaConnectorName: Output<String>? = null

    private var localBrokerConnection: Output<LocalBrokerConnectionSpecArgs>? = null

    private var location: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var mqName: Output<String>? = null

    private var nodeTolerations: Output<NodeTolerationsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The client id prefix of the dynamically generated client ids.
     */
    @JvmName("mpcchppbaukwtmei")
    public suspend fun clientIdPrefix(`value`: Output<String>) {
        this.clientIdPrefix = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("iwabuyirusuqtysy")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The details of KafkaConnector Docker Image.
     */
    @JvmName("ucynputoqwoighct")
    public suspend fun image(`value`: Output<ContainerImageArgs>) {
        this.image = value
    }

    /**
     * @param value The number of KafkaConnector pods to spin up.
     */
    @JvmName("gfxoiosdvpeehirm")
    public suspend fun instances(`value`: Output<Int>) {
        this.instances = value
    }

    /**
     * @param value The details for connecting with Remote Kafka Broker.
     */
    @JvmName("xtisotrmlbjulvwj")
    public suspend fun kafkaConnection(`value`: Output<KafkaRemoteBrokerConnectionSpecArgs>) {
        this.kafkaConnection = value
    }

    /**
     * @param value Name of MQ kafkaConnector resource
     */
    @JvmName("qeomusjdickabhma")
    public suspend fun kafkaConnectorName(`value`: Output<String>) {
        this.kafkaConnectorName = value
    }

    /**
     * @param value The details for connecting with Local Broker.
     */
    @JvmName("raahghldglymicip")
    public suspend fun localBrokerConnection(`value`: Output<LocalBrokerConnectionSpecArgs>) {
        this.localBrokerConnection = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kdshwmidbqnsvxir")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The log level of the Bridge Connector instances.
     */
    @JvmName("dgirehbrtpqtaypj")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("odrvymmihknluieb")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The Node Tolerations for the Bridge Connector pods.
     */
    @JvmName("bousekrmfkncivxs")
    public suspend fun nodeTolerations(`value`: Output<NodeTolerationsArgs>) {
        this.nodeTolerations = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jrqmacwxyjsxqcax")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sbwwfmmdiqxffayu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The client id prefix of the dynamically generated client ids.
     */
    @JvmName("hlntbodgrcscxlgg")
    public suspend fun clientIdPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIdPrefix = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("uexugkbblgkjrdxm")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("bcuwwtropgeariby")
    public suspend
    fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The details of KafkaConnector Docker Image.
     */
    @JvmName("jtagrfrlchpwxjhe")
    public suspend fun image(`value`: ContainerImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument The details of KafkaConnector Docker Image.
     */
    @JvmName("vodwxraxdhemjskx")
    public suspend fun image(argument: suspend ContainerImageArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value The number of KafkaConnector pods to spin up.
     */
    @JvmName("ifwqjwufvfugfphy")
    public suspend fun instances(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The details for connecting with Remote Kafka Broker.
     */
    @JvmName("cgpusejeanxgesqv")
    public suspend fun kafkaConnection(`value`: KafkaRemoteBrokerConnectionSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaConnection = mapped
    }

    /**
     * @param argument The details for connecting with Remote Kafka Broker.
     */
    @JvmName("lyprcdwidgybjulm")
    public suspend
    fun kafkaConnection(argument: suspend KafkaRemoteBrokerConnectionSpecArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaRemoteBrokerConnectionSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kafkaConnection = mapped
    }

    /**
     * @param value Name of MQ kafkaConnector resource
     */
    @JvmName("aatoydxhncntcecg")
    public suspend fun kafkaConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaConnectorName = mapped
    }

    /**
     * @param value The details for connecting with Local Broker.
     */
    @JvmName("ubqunabipbaybrah")
    public suspend fun localBrokerConnection(`value`: LocalBrokerConnectionSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localBrokerConnection = mapped
    }

    /**
     * @param argument The details for connecting with Local Broker.
     */
    @JvmName("gnhqnmhxkdhfpdkb")
    public suspend
    fun localBrokerConnection(argument: suspend LocalBrokerConnectionSpecArgsBuilder.() -> Unit) {
        val toBeMapped = LocalBrokerConnectionSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localBrokerConnection = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jnueixjrlahfcpno")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The log level of the Bridge Connector instances.
     */
    @JvmName("avmbkirwjdmksjya")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("vrnjuqntxfxhkhch")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The Node Tolerations for the Bridge Connector pods.
     */
    @JvmName("bhwpnywcbkbevgej")
    public suspend fun nodeTolerations(`value`: NodeTolerationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeTolerations = mapped
    }

    /**
     * @param argument The Node Tolerations for the Bridge Connector pods.
     */
    @JvmName("pbqnoljjnflgppfb")
    public suspend fun nodeTolerations(argument: suspend NodeTolerationsArgsBuilder.() -> Unit) {
        val toBeMapped = NodeTolerationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodeTolerations = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ysdppcyouxiutnoj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("blvaifibmiugidqs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rvgggcaojungujxv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KafkaConnectorArgs = KafkaConnectorArgs(
        clientIdPrefix = clientIdPrefix,
        extendedLocation = extendedLocation,
        image = image,
        instances = instances,
        kafkaConnection = kafkaConnection,
        kafkaConnectorName = kafkaConnectorName,
        localBrokerConnection = localBrokerConnection,
        location = location,
        logLevel = logLevel,
        mqName = mqName,
        nodeTolerations = nodeTolerations,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
