@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Delta table format supported.
 */
public enum class DeltaTableFormatEnum(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum> {
    /**
     * Bool format
     */
    Boolean_(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Boolean_),

    /**
     * Signed integer 8
     */
    Int8(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Int8),

    /**
     * Signed integer 16
     */
    Int16(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Int16),

    /**
     * Signed integer 32
     */
    Int32(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Int32),

    /**
     * Unsigned integer 8
     */
    UInt8(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.UInt8),

    /**
     * Unsigned integer 16
     */
    UInt16(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.UInt16),

    /**
     * Unsigned integer 32
     */
    UInt32(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.UInt32),

    /**
     * Unsigned integer 64
     */
    UInt64(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.UInt64),

    /**
     * Float 16
     */
    Float16(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Float16),

    /**
     * Float 32
     */
    Float32(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Float32),

    /**
     * Float 64
     */
    Float64(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Float64),

    /**
     * Date 32
     */
    Date32(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Date32),

    /**
     * Date 64
     */
    Date64(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Date64),

    /**
     * Binary data
     */
    Binary(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Binary),

    /**
     * UTF8 format
     */
    Utf8(com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum.Utf8),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.DeltaTableFormatEnum):
            DeltaTableFormatEnum = DeltaTableFormatEnum.values().first { it.javaValue == javaType }
    }
}
