@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The protocol to use for connecting with Brokers.
 */
public enum class MqttProtocol(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.MqttProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.MqttProtocol> {
    /**
     * Mqttv3
     */
    V3(com.pulumi.azurenative.iotoperationsmq.enums.MqttProtocol.V3),

    /**
     * Mqttv5
     */
    V5(com.pulumi.azurenative.iotoperationsmq.enums.MqttProtocol.V5),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.MqttProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.MqttProtocol):
            MqttProtocol = MqttProtocol.values().first { it.javaValue == javaType }
    }
}
