@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BackendChainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Desired properties of the Frontend Instances of the DMQTT Broker
 * @property partitions Partitions is desired number of physical backend chains of the given distributed MQTT broker.
 * @property redundancyFactor Redundancy Factor is desired numbers of broker instances in one chain.
 * @property temporaryDiskTransferEnabled Defines whether disk transfer is enabled or not.
 * @property temporaryDiskTransferHighWatermarkPercent Defines the percentage usage of buffer pool above which disk transfer will start.
 * @property temporaryDiskTransferLowWatermarkPercent Defines the percentage usage of buffer pool below which disk transfer will stop.
 * @property temporaryMaxBackendMemUsagePercent Defines the limits for memory usage percent of the backend instances of the MQTT broker.
 * @property temporaryResourceLimits Defines the limits for resources of the backend instances of the MQTT broker.
 * @property workers Number of logical backend workers per pod.
 */
public data class BackendChainArgs(
    public val partitions: Output<Int>,
    public val redundancyFactor: Output<Int>,
    public val temporaryDiskTransferEnabled: Output<Boolean>? = null,
    public val temporaryDiskTransferHighWatermarkPercent: Output<Int>? = null,
    public val temporaryDiskTransferLowWatermarkPercent: Output<Int>? = null,
    public val temporaryMaxBackendMemUsagePercent: Output<Int>? = null,
    public val temporaryResourceLimits: Output<TemporaryResourceLimitsConfigArgs>? = null,
    public val workers: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BackendChainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.BackendChainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.BackendChainArgs.builder()
            .partitions(partitions.applyValue({ args0 -> args0 }))
            .redundancyFactor(redundancyFactor.applyValue({ args0 -> args0 }))
            .temporaryDiskTransferEnabled(temporaryDiskTransferEnabled?.applyValue({ args0 -> args0 }))
            .temporaryDiskTransferHighWatermarkPercent(
                temporaryDiskTransferHighWatermarkPercent?.applyValue({ args0 ->
                    args0
                }),
            )
            .temporaryDiskTransferLowWatermarkPercent(
                temporaryDiskTransferLowWatermarkPercent?.applyValue({ args0 ->
                    args0
                }),
            )
            .temporaryMaxBackendMemUsagePercent(
                temporaryMaxBackendMemUsagePercent?.applyValue({ args0 ->
                    args0
                }),
            )
            .temporaryResourceLimits(
                temporaryResourceLimits?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workers(workers?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendChainArgs].
 */
@PulumiTagMarker
public class BackendChainArgsBuilder internal constructor() {
    private var partitions: Output<Int>? = null

    private var redundancyFactor: Output<Int>? = null

    private var temporaryDiskTransferEnabled: Output<Boolean>? = null

    private var temporaryDiskTransferHighWatermarkPercent: Output<Int>? = null

    private var temporaryDiskTransferLowWatermarkPercent: Output<Int>? = null

    private var temporaryMaxBackendMemUsagePercent: Output<Int>? = null

    private var temporaryResourceLimits: Output<TemporaryResourceLimitsConfigArgs>? = null

    private var workers: Output<Int>? = null

    /**
     * @param value Partitions is desired number of physical backend chains of the given distributed MQTT broker.
     */
    @JvmName("hmhotgljfphnqewe")
    public suspend fun partitions(`value`: Output<Int>) {
        this.partitions = value
    }

    /**
     * @param value Redundancy Factor is desired numbers of broker instances in one chain.
     */
    @JvmName("grtyihyvmntyqedy")
    public suspend fun redundancyFactor(`value`: Output<Int>) {
        this.redundancyFactor = value
    }

    /**
     * @param value Defines whether disk transfer is enabled or not.
     */
    @JvmName("eycrteutlassjuxi")
    public suspend fun temporaryDiskTransferEnabled(`value`: Output<Boolean>) {
        this.temporaryDiskTransferEnabled = value
    }

    /**
     * @param value Defines the percentage usage of buffer pool above which disk transfer will start.
     */
    @JvmName("hyhkbsirhdwsltna")
    public suspend fun temporaryDiskTransferHighWatermarkPercent(`value`: Output<Int>) {
        this.temporaryDiskTransferHighWatermarkPercent = value
    }

    /**
     * @param value Defines the percentage usage of buffer pool below which disk transfer will stop.
     */
    @JvmName("bybgibhtcbirsnbs")
    public suspend fun temporaryDiskTransferLowWatermarkPercent(`value`: Output<Int>) {
        this.temporaryDiskTransferLowWatermarkPercent = value
    }

    /**
     * @param value Defines the limits for memory usage percent of the backend instances of the MQTT broker.
     */
    @JvmName("fdalljbyctpigydq")
    public suspend fun temporaryMaxBackendMemUsagePercent(`value`: Output<Int>) {
        this.temporaryMaxBackendMemUsagePercent = value
    }

    /**
     * @param value Defines the limits for resources of the backend instances of the MQTT broker.
     */
    @JvmName("dvtnkxuxxddndmgb")
    public suspend fun temporaryResourceLimits(`value`: Output<TemporaryResourceLimitsConfigArgs>) {
        this.temporaryResourceLimits = value
    }

    /**
     * @param value Number of logical backend workers per pod.
     */
    @JvmName("bkgdnmmrdkeqtwol")
    public suspend fun workers(`value`: Output<Int>) {
        this.workers = value
    }

    /**
     * @param value Partitions is desired number of physical backend chains of the given distributed MQTT broker.
     */
    @JvmName("mmegedwaabbruafp")
    public suspend fun partitions(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitions = mapped
    }

    /**
     * @param value Redundancy Factor is desired numbers of broker instances in one chain.
     */
    @JvmName("uyqdixyhgvvvchpc")
    public suspend fun redundancyFactor(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redundancyFactor = mapped
    }

    /**
     * @param value Defines whether disk transfer is enabled or not.
     */
    @JvmName("qmujtrscohjlakxc")
    public suspend fun temporaryDiskTransferEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryDiskTransferEnabled = mapped
    }

    /**
     * @param value Defines the percentage usage of buffer pool above which disk transfer will start.
     */
    @JvmName("riruuimpsatttqtw")
    public suspend fun temporaryDiskTransferHighWatermarkPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryDiskTransferHighWatermarkPercent = mapped
    }

    /**
     * @param value Defines the percentage usage of buffer pool below which disk transfer will stop.
     */
    @JvmName("vthjlrybdnrugppm")
    public suspend fun temporaryDiskTransferLowWatermarkPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryDiskTransferLowWatermarkPercent = mapped
    }

    /**
     * @param value Defines the limits for memory usage percent of the backend instances of the MQTT broker.
     */
    @JvmName("vkkcsipkautmgcyq")
    public suspend fun temporaryMaxBackendMemUsagePercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryMaxBackendMemUsagePercent = mapped
    }

    /**
     * @param value Defines the limits for resources of the backend instances of the MQTT broker.
     */
    @JvmName("qqfucetacqpiapmr")
    public suspend fun temporaryResourceLimits(`value`: TemporaryResourceLimitsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryResourceLimits = mapped
    }

    /**
     * @param argument Defines the limits for resources of the backend instances of the MQTT broker.
     */
    @JvmName("jprlnkleqbjjrsff")
    public suspend
    fun temporaryResourceLimits(argument: suspend TemporaryResourceLimitsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = TemporaryResourceLimitsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.temporaryResourceLimits = mapped
    }

    /**
     * @param value Number of logical backend workers per pod.
     */
    @JvmName("ppcawnpcerkyyetq")
    public suspend fun workers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workers = mapped
    }

    internal fun build(): BackendChainArgs = BackendChainArgs(
        partitions = partitions ?: throw PulumiNullFieldException("partitions"),
        redundancyFactor = redundancyFactor ?: throw PulumiNullFieldException("redundancyFactor"),
        temporaryDiskTransferEnabled = temporaryDiskTransferEnabled,
        temporaryDiskTransferHighWatermarkPercent = temporaryDiskTransferHighWatermarkPercent,
        temporaryDiskTransferLowWatermarkPercent = temporaryDiskTransferLowWatermarkPercent,
        temporaryMaxBackendMemUsagePercent = temporaryMaxBackendMemUsagePercent,
        temporaryResourceLimits = temporaryResourceLimits,
        workers = workers,
    )
}
