@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodUsernamePasswordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * UsernamePassword for BrokerAuthentication
 * @property keyVault Keyvault username password secret properties.
 * @property secretName Secret where username and password are stored.
 */
public data class BrokerAuthenticatorMethodUsernamePasswordArgs(
    public val keyVault: Output<KeyVaultSecretPropertiesArgs>? = null,
    public val secretName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodUsernamePasswordArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodUsernamePasswordArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodUsernamePasswordArgs.builder()
            .keyVault(keyVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretName(secretName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerAuthenticatorMethodUsernamePasswordArgs].
 */
@PulumiTagMarker
public class BrokerAuthenticatorMethodUsernamePasswordArgsBuilder internal constructor() {
    private var keyVault: Output<KeyVaultSecretPropertiesArgs>? = null

    private var secretName: Output<String>? = null

    /**
     * @param value Keyvault username password secret properties.
     */
    @JvmName("njjggkuqcoovannl")
    public suspend fun keyVault(`value`: Output<KeyVaultSecretPropertiesArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Secret where username and password are stored.
     */
    @JvmName("yshnexolwryivlkm")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value Keyvault username password secret properties.
     */
    @JvmName("olfjcmhdbgnrhxvq")
    public suspend fun keyVault(`value`: KeyVaultSecretPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument Keyvault username password secret properties.
     */
    @JvmName("gnyrqvtxydmjiyif")
    public suspend fun keyVault(argument: suspend KeyVaultSecretPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Secret where username and password are stored.
     */
    @JvmName("cygqgfeugyuvubhi")
    public suspend fun secretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    internal fun build(): BrokerAuthenticatorMethodUsernamePasswordArgs =
        BrokerAuthenticatorMethodUsernamePasswordArgs(
            keyVault = keyVault,
            secretName = secretName,
        )
}
