@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Delta table properties
 * @property schema Schema list supported.
 * @property tableName Delta table name.
 * @property tablePath Delta table path.
 */
public data class DeltaTableArgs(
    public val schema: Output<List<DeltaTableSchemaArgs>>,
    public val tableName: Output<String>,
    public val tablePath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableArgs.builder()
            .schema(schema.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tableName(tableName.applyValue({ args0 -> args0 }))
            .tablePath(tablePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeltaTableArgs].
 */
@PulumiTagMarker
public class DeltaTableArgsBuilder internal constructor() {
    private var schema: Output<List<DeltaTableSchemaArgs>>? = null

    private var tableName: Output<String>? = null

    private var tablePath: Output<String>? = null

    /**
     * @param value Schema list supported.
     */
    @JvmName("fhtsjrtpaxiusecp")
    public suspend fun schema(`value`: Output<List<DeltaTableSchemaArgs>>) {
        this.schema = value
    }

    @JvmName("epfwdlmpxjxwdeuc")
    public suspend fun schema(vararg values: Output<DeltaTableSchemaArgs>) {
        this.schema = Output.all(values.asList())
    }

    /**
     * @param values Schema list supported.
     */
    @JvmName("cdnxmxrmawbtdoco")
    public suspend fun schema(values: List<Output<DeltaTableSchemaArgs>>) {
        this.schema = Output.all(values)
    }

    /**
     * @param value Delta table name.
     */
    @JvmName("uhjerpljjdkaqoid")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value Delta table path.
     */
    @JvmName("lykwutsmvgpqtnqt")
    public suspend fun tablePath(`value`: Output<String>) {
        this.tablePath = value
    }

    /**
     * @param value Schema list supported.
     */
    @JvmName("qxavgdhvqxuepsjg")
    public suspend fun schema(`value`: List<DeltaTableSchemaArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument Schema list supported.
     */
    @JvmName("msxjrgambwddcjrt")
    public suspend fun schema(argument: List<suspend DeltaTableSchemaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeltaTableSchemaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param argument Schema list supported.
     */
    @JvmName("efliuedvsdqyshod")
    public suspend fun schema(vararg argument: suspend DeltaTableSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeltaTableSchemaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param argument Schema list supported.
     */
    @JvmName("roixdvbynrrhflpm")
    public suspend fun schema(argument: suspend DeltaTableSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DeltaTableSchemaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param values Schema list supported.
     */
    @JvmName("qmdyuuuevpquoxvd")
    public suspend fun schema(vararg values: DeltaTableSchemaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Delta table name.
     */
    @JvmName("jfldpmxeekfqcvmv")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value Delta table path.
     */
    @JvmName("ilqfbiryspqsuivw")
    public suspend fun tablePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablePath = mapped
    }

    internal fun build(): DeltaTableArgs = DeltaTableArgs(
        schema = schema ?: throw PulumiNullFieldException("schema"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        tablePath = tablePath,
    )
}
