@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DiskBackedMessageBufferSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DiskBackedMessageBufferSettings properties
 * @property ephemeralVolumeClaimSpec Use the specified persistent volume claim template to mount a "generic ephemeral volume" for the message buffer. See <https://kubernetes.io/docs/concepts/storage/ephemeral-volumes/#generic-ephemeral-volumes> for details.
 * @property maxSize The max size of the message buffer on disk. If a PVC template is specified using one of ephemeralVolumeClaimSpec or persistentVolumeClaimSpec, then this size is used as the request and limit sizes of that template. If neither ephemeralVolumeClaimSpec nor persistentVolumeClaimSpec are specified, then an emptyDir volume is mounted with this size as its limit. See <https://kubernetes.io/docs/concepts/storage/volumes/#emptydir> for details.
 * @property persistentVolumeClaimSpec Use the specified persistent volume claim template to mount a persistent volume for the message buffer.
 */
public data class DiskBackedMessageBufferSettingsArgs(
    public val ephemeralVolumeClaimSpec: Output<VolumeClaimSpecArgs>? = null,
    public val maxSize: Output<String>,
    public val persistentVolumeClaimSpec: Output<VolumeClaimSpecArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DiskBackedMessageBufferSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.DiskBackedMessageBufferSettingsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DiskBackedMessageBufferSettingsArgs.builder()
            .ephemeralVolumeClaimSpec(
                ephemeralVolumeClaimSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .maxSize(maxSize.applyValue({ args0 -> args0 }))
            .persistentVolumeClaimSpec(
                persistentVolumeClaimSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DiskBackedMessageBufferSettingsArgs].
 */
@PulumiTagMarker
public class DiskBackedMessageBufferSettingsArgsBuilder internal constructor() {
    private var ephemeralVolumeClaimSpec: Output<VolumeClaimSpecArgs>? = null

    private var maxSize: Output<String>? = null

    private var persistentVolumeClaimSpec: Output<VolumeClaimSpecArgs>? = null

    /**
     * @param value Use the specified persistent volume claim template to mount a "generic ephemeral volume" for the message buffer. See <https://kubernetes.io/docs/concepts/storage/ephemeral-volumes/#generic-ephemeral-volumes> for details.
     */
    @JvmName("dmssdhmrlcpiqfkr")
    public suspend fun ephemeralVolumeClaimSpec(`value`: Output<VolumeClaimSpecArgs>) {
        this.ephemeralVolumeClaimSpec = value
    }

    /**
     * @param value The max size of the message buffer on disk. If a PVC template is specified using one of ephemeralVolumeClaimSpec or persistentVolumeClaimSpec, then this size is used as the request and limit sizes of that template. If neither ephemeralVolumeClaimSpec nor persistentVolumeClaimSpec are specified, then an emptyDir volume is mounted with this size as its limit. See <https://kubernetes.io/docs/concepts/storage/volumes/#emptydir> for details.
     */
    @JvmName("jfbbptwqhrjycgfx")
    public suspend fun maxSize(`value`: Output<String>) {
        this.maxSize = value
    }

    /**
     * @param value Use the specified persistent volume claim template to mount a persistent volume for the message buffer.
     */
    @JvmName("kvjutusuxougyyqs")
    public suspend fun persistentVolumeClaimSpec(`value`: Output<VolumeClaimSpecArgs>) {
        this.persistentVolumeClaimSpec = value
    }

    /**
     * @param value Use the specified persistent volume claim template to mount a "generic ephemeral volume" for the message buffer. See <https://kubernetes.io/docs/concepts/storage/ephemeral-volumes/#generic-ephemeral-volumes> for details.
     */
    @JvmName("popuxnbltvptoyhv")
    public suspend fun ephemeralVolumeClaimSpec(`value`: VolumeClaimSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralVolumeClaimSpec = mapped
    }

    /**
     * @param argument Use the specified persistent volume claim template to mount a "generic ephemeral volume" for the message buffer. See <https://kubernetes.io/docs/concepts/storage/ephemeral-volumes/#generic-ephemeral-volumes> for details.
     */
    @JvmName("tsfvjihrhodjmpqh")
    public suspend
    fun ephemeralVolumeClaimSpec(argument: suspend VolumeClaimSpecArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeClaimSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ephemeralVolumeClaimSpec = mapped
    }

    /**
     * @param value The max size of the message buffer on disk. If a PVC template is specified using one of ephemeralVolumeClaimSpec or persistentVolumeClaimSpec, then this size is used as the request and limit sizes of that template. If neither ephemeralVolumeClaimSpec nor persistentVolumeClaimSpec are specified, then an emptyDir volume is mounted with this size as its limit. See <https://kubernetes.io/docs/concepts/storage/volumes/#emptydir> for details.
     */
    @JvmName("xinqybhwwyncseun")
    public suspend fun maxSize(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value Use the specified persistent volume claim template to mount a persistent volume for the message buffer.
     */
    @JvmName("pbunfxaeihnmvstp")
    public suspend fun persistentVolumeClaimSpec(`value`: VolumeClaimSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistentVolumeClaimSpec = mapped
    }

    /**
     * @param argument Use the specified persistent volume claim template to mount a persistent volume for the message buffer.
     */
    @JvmName("gvmpikxkmjhmosmx")
    public suspend
    fun persistentVolumeClaimSpec(argument: suspend VolumeClaimSpecArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeClaimSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.persistentVolumeClaimSpec = mapped
    }

    internal fun build(): DiskBackedMessageBufferSettingsArgs = DiskBackedMessageBufferSettingsArgs(
        ephemeralVolumeClaimSpec = ephemeralVolumeClaimSpec,
        maxSize = maxSize ?: throw PulumiNullFieldException("maxSize"),
        persistentVolumeClaimSpec = persistentVolumeClaimSpec,
    )
}
