@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetDiagnosticServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property diagnosticServiceName Name of MQ diagnostic resource
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDiagnosticServicePlainArgs(
    public val diagnosticServiceName: String,
    public val mqName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetDiagnosticServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.GetDiagnosticServicePlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetDiagnosticServicePlainArgs.builder()
            .diagnosticServiceName(diagnosticServiceName.let({ args0 -> args0 }))
            .mqName(mqName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiagnosticServicePlainArgs].
 */
@PulumiTagMarker
public class GetDiagnosticServicePlainArgsBuilder internal constructor() {
    private var diagnosticServiceName: String? = null

    private var mqName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of MQ diagnostic resource
     */
    @JvmName("gogsqcqlbletdfqe")
    public suspend fun diagnosticServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diagnosticServiceName = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("hbovdvnmattjdgrv")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mrdlldipjrhwrska")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDiagnosticServicePlainArgs = GetDiagnosticServicePlainArgs(
        diagnosticServiceName = diagnosticServiceName ?: throw
            PulumiNullFieldException("diagnosticServiceName"),
        mqName = mqName ?: throw PulumiNullFieldException("mqName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
