@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetMqttBridgeConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mqName Name of MQ resource
 * @property mqttBridgeConnectorName Name of MQ mqttBridgeConnector resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMqttBridgeConnectorPlainArgs(
    public val mqName: String,
    public val mqttBridgeConnectorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetMqttBridgeConnectorPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.GetMqttBridgeConnectorPlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetMqttBridgeConnectorPlainArgs.builder()
            .mqName(mqName.let({ args0 -> args0 }))
            .mqttBridgeConnectorName(mqttBridgeConnectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMqttBridgeConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetMqttBridgeConnectorPlainArgsBuilder internal constructor() {
    private var mqName: String? = null

    private var mqttBridgeConnectorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of MQ resource
     */
    @JvmName("cgntaipayugnnbxn")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value Name of MQ mqttBridgeConnector resource
     */
    @JvmName("gptyxecnvckdcadm")
    public suspend fun mqttBridgeConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqttBridgeConnectorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dxtsrjducspedqwk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMqttBridgeConnectorPlainArgs = GetMqttBridgeConnectorPlainArgs(
        mqName = mqName ?: throw PulumiNullFieldException("mqName"),
        mqttBridgeConnectorName = mqttBridgeConnectorName ?: throw
            PulumiNullFieldException("mqttBridgeConnectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
