@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kafka RemoteBrokerConnection Authentication methods
 * @property authType The type of authentication to use for Kafka remote broker.
 * @property enabled If authentication is enabled for Kafka remote broker.
 */
public data class KafkaRemoteBrokerAuthenticationPropertiesArgs(
    public val authType: Output<KafkaRemoteBrokerAuthenticationTypesArgs>? = null,
    public val enabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationPropertiesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationPropertiesArgs.builder()
            .authType(authType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KafkaRemoteBrokerAuthenticationPropertiesArgs].
 */
@PulumiTagMarker
public class KafkaRemoteBrokerAuthenticationPropertiesArgsBuilder internal constructor() {
    private var authType: Output<KafkaRemoteBrokerAuthenticationTypesArgs>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The type of authentication to use for Kafka remote broker.
     */
    @JvmName("hmfftjdmeyajmhyj")
    public suspend fun authType(`value`: Output<KafkaRemoteBrokerAuthenticationTypesArgs>) {
        this.authType = value
    }

    /**
     * @param value If authentication is enabled for Kafka remote broker.
     */
    @JvmName("teehsfeoggeeqhgg")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The type of authentication to use for Kafka remote broker.
     */
    @JvmName("yfyuomkjcvhheopc")
    public suspend fun authType(`value`: KafkaRemoteBrokerAuthenticationTypesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param argument The type of authentication to use for Kafka remote broker.
     */
    @JvmName("dflvybcnbcuducvd")
    public suspend
    fun authType(argument: suspend KafkaRemoteBrokerAuthenticationTypesArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaRemoteBrokerAuthenticationTypesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authType = mapped
    }

    /**
     * @param value If authentication is enabled for Kafka remote broker.
     */
    @JvmName("aggkasgjxgpmbkld")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): KafkaRemoteBrokerAuthenticationPropertiesArgs =
        KafkaRemoteBrokerAuthenticationPropertiesArgs(
            authType = authType,
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
