@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaSharedSubscriptionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Kafka Shared Subscription properties
 * @property groupMinimumShareNumber The minimum number to use in a group for subscription.
 * @property groupName The name of the shared subscription.
 */
public data class KafkaSharedSubscriptionPropertiesArgs(
    public val groupMinimumShareNumber: Output<Int>,
    public val groupName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KafkaSharedSubscriptionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaSharedSubscriptionPropertiesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaSharedSubscriptionPropertiesArgs.builder()
            .groupMinimumShareNumber(groupMinimumShareNumber.applyValue({ args0 -> args0 }))
            .groupName(groupName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KafkaSharedSubscriptionPropertiesArgs].
 */
@PulumiTagMarker
public class KafkaSharedSubscriptionPropertiesArgsBuilder internal constructor() {
    private var groupMinimumShareNumber: Output<Int>? = null

    private var groupName: Output<String>? = null

    /**
     * @param value The minimum number to use in a group for subscription.
     */
    @JvmName("loixsctumxqwvwbv")
    public suspend fun groupMinimumShareNumber(`value`: Output<Int>) {
        this.groupMinimumShareNumber = value
    }

    /**
     * @param value The name of the shared subscription.
     */
    @JvmName("ibufbivgsuxditdf")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The minimum number to use in a group for subscription.
     */
    @JvmName("nypgcdyhvfstucca")
    public suspend fun groupMinimumShareNumber(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupMinimumShareNumber = mapped
    }

    /**
     * @param value The name of the shared subscription.
     */
    @JvmName("kwafripyvstjymil")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    internal fun build(): KafkaSharedSubscriptionPropertiesArgs =
        KafkaSharedSubscriptionPropertiesArgs(
            groupMinimumShareNumber = groupMinimumShareNumber ?: throw
                PulumiNullFieldException("groupMinimumShareNumber"),
            groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        )
}
