@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultConnectionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * KeyVault properties
 * @property credentials KeyVault credentials.
 * @property directoryId KeyVault directoryId.
 * @property name KeyVault name.
 */
public data class KeyVaultConnectionPropertiesArgs(
    public val credentials: Output<KeyVaultCredentialsPropertiesArgs>,
    public val directoryId: Output<String>,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultConnectionPropertiesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultConnectionPropertiesArgs.builder()
            .credentials(credentials.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .directoryId(directoryId.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultConnectionPropertiesArgsBuilder internal constructor() {
    private var credentials: Output<KeyVaultCredentialsPropertiesArgs>? = null

    private var directoryId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value KeyVault credentials.
     */
    @JvmName("wbjbkbqumkupfefc")
    public suspend fun credentials(`value`: Output<KeyVaultCredentialsPropertiesArgs>) {
        this.credentials = value
    }

    /**
     * @param value KeyVault directoryId.
     */
    @JvmName("wbtigbyrtlubujlw")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value KeyVault name.
     */
    @JvmName("uyerkthnlmggydmo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value KeyVault credentials.
     */
    @JvmName("vtrrnubsgxxkvhed")
    public suspend fun credentials(`value`: KeyVaultCredentialsPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument KeyVault credentials.
     */
    @JvmName("kfqmesmwgaghwhne")
    public suspend
    fun credentials(argument: suspend KeyVaultCredentialsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultCredentialsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value KeyVault directoryId.
     */
    @JvmName("pbcfuocmoyejrxyf")
    public suspend fun directoryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value KeyVault name.
     */
    @JvmName("qulvwfptpwypuirg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): KeyVaultConnectionPropertiesArgs = KeyVaultConnectionPropertiesArgs(
        credentials = credentials ?: throw PulumiNullFieldException("credentials"),
        directoryId = directoryId ?: throw PulumiNullFieldException("directoryId"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
