@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Mqtt Local Broker Connection TLS details
 * @property tlsEnabled Tls Enabled on Local Broker Connection.
 * @property trustedCaCertificateConfigMap Trusted CA certificate config map name for Local Broker.
 */
public data class LocalBrokerConnectionTlsArgs(
    public val tlsEnabled: Output<Boolean>? = null,
    public val trustedCaCertificateConfigMap: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionTlsArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionTlsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionTlsArgs.builder()
            .tlsEnabled(tlsEnabled?.applyValue({ args0 -> args0 }))
            .trustedCaCertificateConfigMap(
                trustedCaCertificateConfigMap?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [LocalBrokerConnectionTlsArgs].
 */
@PulumiTagMarker
public class LocalBrokerConnectionTlsArgsBuilder internal constructor() {
    private var tlsEnabled: Output<Boolean>? = null

    private var trustedCaCertificateConfigMap: Output<String>? = null

    /**
     * @param value Tls Enabled on Local Broker Connection.
     */
    @JvmName("isijtqbfijdikjpc")
    public suspend fun tlsEnabled(`value`: Output<Boolean>) {
        this.tlsEnabled = value
    }

    /**
     * @param value Trusted CA certificate config map name for Local Broker.
     */
    @JvmName("odmnqevnxbcpqhad")
    public suspend fun trustedCaCertificateConfigMap(`value`: Output<String>) {
        this.trustedCaCertificateConfigMap = value
    }

    /**
     * @param value Tls Enabled on Local Broker Connection.
     */
    @JvmName("bothfmpkwjvxuqwj")
    public suspend fun tlsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsEnabled = mapped
    }

    /**
     * @param value Trusted CA certificate config map name for Local Broker.
     */
    @JvmName("cktilrkevrltsrel")
    public suspend fun trustedCaCertificateConfigMap(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCaCertificateConfigMap = mapped
    }

    internal fun build(): LocalBrokerConnectionTlsArgs = LocalBrokerConnectionTlsArgs(
        tlsEnabled = tlsEnabled,
        trustedCaCertificateConfigMap = trustedCaCertificateConfigMap,
    )
}
