@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * MqttBridge RemoteBrokerConnection TLS details
 * @property tlsEnabled Tls Enabled on Remote Broker Connection.
 * @property trustedCaCertificateConfigMap Trusted CA certificate name for Remote Broker.
 */
public data class MqttBridgeRemoteBrokerConnectionTlsArgs(
    public val tlsEnabled: Output<Boolean>,
    public val trustedCaCertificateConfigMap: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionTlsArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionTlsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerConnectionTlsArgs.builder()
            .tlsEnabled(tlsEnabled.applyValue({ args0 -> args0 }))
            .trustedCaCertificateConfigMap(
                trustedCaCertificateConfigMap?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MqttBridgeRemoteBrokerConnectionTlsArgs].
 */
@PulumiTagMarker
public class MqttBridgeRemoteBrokerConnectionTlsArgsBuilder internal constructor() {
    private var tlsEnabled: Output<Boolean>? = null

    private var trustedCaCertificateConfigMap: Output<String>? = null

    /**
     * @param value Tls Enabled on Remote Broker Connection.
     */
    @JvmName("erbymxjhgerinfao")
    public suspend fun tlsEnabled(`value`: Output<Boolean>) {
        this.tlsEnabled = value
    }

    /**
     * @param value Trusted CA certificate name for Remote Broker.
     */
    @JvmName("iskylgspmjtudhyp")
    public suspend fun trustedCaCertificateConfigMap(`value`: Output<String>) {
        this.trustedCaCertificateConfigMap = value
    }

    /**
     * @param value Tls Enabled on Remote Broker Connection.
     */
    @JvmName("vdqspseffbtkrdim")
    public suspend fun tlsEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tlsEnabled = mapped
    }

    /**
     * @param value Trusted CA certificate name for Remote Broker.
     */
    @JvmName("dntgfbtchqnjhhkb")
    public suspend fun trustedCaCertificateConfigMap(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCaCertificateConfigMap = mapped
    }

    internal fun build(): MqttBridgeRemoteBrokerConnectionTlsArgs =
        MqttBridgeRemoteBrokerConnectionTlsArgs(
            tlsEnabled = tlsEnabled ?: throw PulumiNullFieldException("tlsEnabled"),
            trustedCaCertificateConfigMap = trustedCaCertificateConfigMap,
        )
}
