@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimResourceRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VolumeClaimResourceRequirements properties
 * @property limits Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
 * @property requests Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
 */
public data class VolumeClaimResourceRequirementsArgs(
    public val limits: Output<Map<String, String>>? = null,
    public val requests: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimResourceRequirementsArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimResourceRequirementsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimResourceRequirementsArgs.builder()
            .limits(limits?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .requests(
                requests?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VolumeClaimResourceRequirementsArgs].
 */
@PulumiTagMarker
public class VolumeClaimResourceRequirementsArgsBuilder internal constructor() {
    private var limits: Output<Map<String, String>>? = null

    private var requests: Output<Map<String, String>>? = null

    /**
     * @param value Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     */
    @JvmName("usbppasqrbstpdkv")
    public suspend fun limits(`value`: Output<Map<String, String>>) {
        this.limits = value
    }

    /**
     * @param value Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     */
    @JvmName("gxksnxtufvbcxlgl")
    public suspend fun requests(`value`: Output<Map<String, String>>) {
        this.requests = value
    }

    /**
     * @param value Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     */
    @JvmName("uqbjgvmywedbrgii")
    public suspend fun limits(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param values Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     */
    @JvmName("konwedmwftpwqkyd")
    public fun limits(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param value Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     */
    @JvmName("vjwnsyuoeetiuwbt")
    public suspend fun requests(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param values Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
     */
    @JvmName("drkhphkexlqlwomm")
    public fun requests(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    internal fun build(): VolumeClaimResourceRequirementsArgs = VolumeClaimResourceRequirementsArgs(
        limits = limits,
        requests = requests,
    )
}
