@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * BrokerAuthenticatorMethodX509Attributes properties. NOTE - Enum only type supported at a time.
 * @property keyVault Keyvault x509 attributes secret properties.
 * @property secretName Secret where x509 attributes are stored.
 */
public data class BrokerAuthenticatorMethodX509AttributesResponse(
    public val keyVault: KeyVaultSecretPropertiesResponse? = null,
    public val secretName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.BrokerAuthenticatorMethodX509AttributesResponse):
            BrokerAuthenticatorMethodX509AttributesResponse =
            BrokerAuthenticatorMethodX509AttributesResponse(
                keyVault = javaType.keyVault().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultSecretPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                secretName = javaType.secretName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
