@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * Collection of different CrdAuthenticator methods of Broker Resource. NOTE Enum - Only one method is supported for each entry.
 * @property custom Custom Authentication Method.
 * @property sat Service Account Token Method.
 * @property svid Service Account Token Method.
 * @property usernamePassword UsernamePassword Method.
 * @property x509 X509 Method.
 */
public data class BrokerAuthenticatorMethodsResponse(
    public val custom: BrokerAuthenticatorMethodCustomResponse? = null,
    public val sat: BrokerAuthenticatorMethodSatResponse? = null,
    public val svid: BrokerAuthenticatorMethodSvidResponse? = null,
    public val usernamePassword: BrokerAuthenticatorMethodUsernamePasswordResponse? = null,
    public val x509: BrokerAuthenticatorMethodX509Response? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.BrokerAuthenticatorMethodsResponse):
            BrokerAuthenticatorMethodsResponse = BrokerAuthenticatorMethodsResponse(
            custom = javaType.custom().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerAuthenticatorMethodCustomResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sat = javaType.sat().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerAuthenticatorMethodSatResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            svid = javaType.svid().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerAuthenticatorMethodSvidResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            usernamePassword = javaType.usernamePassword().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerAuthenticatorMethodUsernamePasswordResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            x509 = javaType.x509().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerAuthenticatorMethodX509Response.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
