@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * Cardinality properties
 * @property backendChain The backend broker desired properties
 * @property frontend The frontend broker desired properties
 */
public data class CardinalityResponse(
    public val backendChain: BackendChainResponse,
    public val frontend: FrontendResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.CardinalityResponse):
            CardinalityResponse = CardinalityResponse(
            backendChain = javaType.backendChain().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BackendChainResponse.Companion.toKotlin(args0)
            }),
            frontend = javaType.frontend().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.FrontendResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
