@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cert-Manager issuerRef properties
 * @property group group of issuer.
 * @property kind kind of issuer (Issuer or ClusterIssuer).
 * @property name name of issuer.
 */
public data class CertManagerIssuerRefResponse(
    public val group: String,
    public val kind: String,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.CertManagerIssuerRefResponse):
            CertManagerIssuerRefResponse = CertManagerIssuerRefResponse(
            group = javaType.group(),
            kind = javaType.kind(),
            name = javaType.name(),
        )
    }
}
