@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * MQ broker/listener resource
 * @property authenticationEnabled The flag for enabling Authentication rules on Listener Port.
 * @property authorizationEnabled The flag for enabling Authorization policies on Listener Port. false - AllowAll, true - Use Authorization resource rules if present.
 * @property brokerRef The k8s cr/resource reference of mq/broker.
 * @property extendedLocation Extended Location
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property nodePort The node port to use on the Host node.
 * @property port The port to start Listening for connections on.
 * @property provisioningState The status of the last operation.
 * @property serviceName The service name to expose Listener port on.
 * @property serviceType The Kubernetes Service type to deploy for Listener.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property tls Defines configuration of a TLS server certificate. NOTE Enum - Only one TLS Cert method is supported
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetBrokerListenerResult(
    public val authenticationEnabled: Boolean? = null,
    public val authorizationEnabled: Boolean? = null,
    public val brokerRef: String,
    public val extendedLocation: ExtendedLocationPropertyResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val nodePort: Int? = null,
    public val port: Int,
    public val provisioningState: String,
    public val serviceName: String? = null,
    public val serviceType: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tls: TlsCertMethodResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.GetBrokerListenerResult):
            GetBrokerListenerResult = GetBrokerListenerResult(
            authenticationEnabled = javaType.authenticationEnabled().map({ args0 -> args0 }).orElse(null),
            authorizationEnabled = javaType.authorizationEnabled().map({ args0 -> args0 }).orElse(null),
            brokerRef = javaType.brokerRef(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            nodePort = javaType.nodePort().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
            provisioningState = javaType.provisioningState(),
            serviceName = javaType.serviceName().map({ args0 -> args0 }).orElse(null),
            serviceType = javaType.serviceType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.TlsCertMethodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
