@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Kafka Shared Subscription properties
 * @property groupMinimumShareNumber The minimum number to use in a group for subscription.
 * @property groupName The name of the shared subscription.
 */
public data class KafkaSharedSubscriptionPropertiesResponse(
    public val groupMinimumShareNumber: Int,
    public val groupName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaSharedSubscriptionPropertiesResponse):
            KafkaSharedSubscriptionPropertiesResponse = KafkaSharedSubscriptionPropertiesResponse(
            groupMinimumShareNumber = javaType.groupMinimumShareNumber(),
            groupName = javaType.groupName(),
        )
    }
}
