@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * Mqtt Local Broker Authentication details. Only one method at a time is supported. Default - kubernetes authentication
 * @property kubernetes Kubernetes local broker authentication method.
 */
public data class LocalBrokerAuthenticationMethodsResponse(
    public val kubernetes: LocalBrokerKubernetesAuthenticationResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.LocalBrokerAuthenticationMethodsResponse):
            LocalBrokerAuthenticationMethodsResponse = LocalBrokerAuthenticationMethodsResponse(
            kubernetes = javaType.kubernetes().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerKubernetesAuthenticationResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
