@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Kafka RemoteBrokerConnection Sasl Authentication properties.
 * @property saslType Sasl Mechanism for remote broker authentication.
 * @property token Sasl token for remote broker authentication.
 */
public data class SaslRemoteBrokerBasicAuthenticationResponse(
    public val saslType: String,
    public val token: SaslRemoteBrokerBasicAuthenticationTokenResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.SaslRemoteBrokerBasicAuthenticationResponse):
            SaslRemoteBrokerBasicAuthenticationResponse = SaslRemoteBrokerBasicAuthenticationResponse(
            saslType = javaType.saslType(),
            token = javaType.token().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SaslRemoteBrokerBasicAuthenticationTokenResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
