@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin

import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ReconciliationPolicyResponse
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.TargetSelectorPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ReconciliationPolicyResponse.Companion.toKotlin as reconciliationPolicyResponseToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.TargetSelectorPropertiesResponse.Companion.toKotlin as targetSelectorPropertiesResponseToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsorchestrator.Instance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Instance(builtJavaResource)
    }
}

/**
 * A Instance resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Instances_CreateOrUpdate - generated by [MaximumSet] rule - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instance = new AzureNative.IoTOperationsOrchestrator.Instance("instance", new()
 *     {
 *         ExtendedLocation = new AzureNative.IoTOperationsOrchestrator.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "bjjhfqsplgzdlbdlddleetyg",
 *             Type = "sosibrbmmrfbbyp",
 *         },
 *         Location = "uzehbktba",
 *         Name = "j6-r05-43h--55-q97-9ig--6w44a-2--3g-k53-13263ncl6-2q-h0-q5",
 *         ReconciliationPolicy = new AzureNative.IoTOperationsOrchestrator.Inputs.ReconciliationPolicyArgs
 *         {
 *             Interval = "wyrrzydmfgzymvzbppscxyfobku",
 *             Type = "periodic",
 *         },
 *         ResourceGroupName = "rgopenapi",
 *         Scope = "rkargnjeljnivwjly",
 *         Solution = "p",
 *         Tags = null,
 *         Target = new AzureNative.IoTOperationsOrchestrator.Inputs.TargetSelectorPropertiesArgs
 *         {
 *             Name = "mqxcv",
 *         },
 *         Version = "nf",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsorchestrator/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsorchestrator.NewInstance(ctx, "instance", &iotoperationsorchestrator.InstanceArgs{
 * 			ExtendedLocation: &iotoperationsorchestrator.ExtendedLocationArgs{
 * 				Name: pulumi.String("bjjhfqsplgzdlbdlddleetyg"),
 * 				Type: pulumi.String("sosibrbmmrfbbyp"),
 * 			},
 * 			Location: pulumi.String("uzehbktba"),
 * 			Name:     pulumi.String("j6-r05-43h--55-q97-9ig--6w44a-2--3g-k53-13263ncl6-2q-h0-q5"),
 * 			ReconciliationPolicy: &iotoperationsorchestrator.ReconciliationPolicyArgs{
 * 				Interval: pulumi.String("wyrrzydmfgzymvzbppscxyfobku"),
 * 				Type:     pulumi.String("periodic"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Scope:             pulumi.String("rkargnjeljnivwjly"),
 * 			Solution:          pulumi.String("p"),
 * 			Tags:              nil,
 * 			Target: &iotoperationsorchestrator.TargetSelectorPropertiesArgs{
 * 				Name: pulumi.String("mqxcv"),
 * 			},
 * 			Version: pulumi.String("nf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsorchestrator.Instance;
 * import com.pulumi.azurenative.iotoperationsorchestrator.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "bjjhfqsplgzdlbdlddleetyg"),
 *                 Map.entry("type", "sosibrbmmrfbbyp")
 *             ))
 *             .location("uzehbktba")
 *             .name("j6-r05-43h--55-q97-9ig--6w44a-2--3g-k53-13263ncl6-2q-h0-q5")
 *             .reconciliationPolicy(Map.ofEntries(
 *                 Map.entry("interval", "wyrrzydmfgzymvzbppscxyfobku"),
 *                 Map.entry("type", "periodic")
 *             ))
 *             .resourceGroupName("rgopenapi")
 *             .scope("rkargnjeljnivwjly")
 *             .solution("p")
 *             .tags()
 *             .target(Map.of("name", "mqxcv"))
 *             .version("nf")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsorchestrator:Instance sauintupvjhadznpynqhfjdzjgu /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsOrchestrator/instances/{name}
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsorchestrator.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Edge location of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Reconciliation Policy.
     */
    public val reconciliationPolicy: Output<ReconciliationPolicyResponse>?
        get() = javaResource.reconciliationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> reconciliationPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Deployment scope (such as Kubernetes namespace).
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the solution.
     */
    public val solution: Output<String>?
        get() = javaResource.solution().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Defines the Target the Instance will deploy to.
     */
    public val target: Output<TargetSelectorPropertiesResponse>?
        get() = javaResource.target().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    targetSelectorPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the particular resource.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsorchestrator.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.azurenative.iotoperationsorchestrator.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit):
    Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
