@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin

import com.pulumi.azurenative.iotoperationsorchestrator.IotoperationsorchestratorFunctions.getInstancePlain
import com.pulumi.azurenative.iotoperationsorchestrator.IotoperationsorchestratorFunctions.getSolutionPlain
import com.pulumi.azurenative.iotoperationsorchestrator.IotoperationsorchestratorFunctions.getTargetPlain
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.GetInstancePlainArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.GetInstancePlainArgsBuilder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.GetSolutionPlainArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.GetSolutionPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.GetTargetPlainArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.GetTargetPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.GetInstanceResult
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.GetSolutionResult
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.GetTargetResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.GetInstanceResult.Companion.toKotlin as getInstanceResultToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.GetSolutionResult.Companion.toKotlin as getSolutionResultToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.GetTargetResult.Companion.toKotlin as getTargetResultToKotlin

public object IotoperationsorchestratorFunctions {
    /**
     * Get a Instance
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return A Instance resource belonging to an Instance resource.
     */
    public suspend fun getInstance(argument: GetInstancePlainArgs): GetInstanceResult =
        getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())

    /**
     * @see [getInstance].
     * @param name Name of Instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A Instance resource belonging to an Instance resource.
     */
    public suspend fun getInstance(name: String, resourceGroupName: String): GetInstanceResult {
        val argument = GetInstancePlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsorchestrator&#46;kotlin&#46;inputs&#46;GetInstancePlainArgs].
     * @return A Instance resource belonging to an Instance resource.
     */
    public suspend fun getInstance(argument: suspend GetInstancePlainArgsBuilder.() -> Unit):
        GetInstanceResult {
        val builder = GetInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceResultToKotlin(getInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Solution
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return A Solution resource belonging to an Instance resource.
     */
    public suspend fun getSolution(argument: GetSolutionPlainArgs): GetSolutionResult =
        getSolutionResultToKotlin(getSolutionPlain(argument.toJava()).await())

    /**
     * @see [getSolution].
     * @param name Name of solution.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A Solution resource belonging to an Instance resource.
     */
    public suspend fun getSolution(name: String, resourceGroupName: String): GetSolutionResult {
        val argument = GetSolutionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getSolutionResultToKotlin(getSolutionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSolution].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsorchestrator&#46;kotlin&#46;inputs&#46;GetSolutionPlainArgs].
     * @return A Solution resource belonging to an Instance resource.
     */
    public suspend fun getSolution(argument: suspend GetSolutionPlainArgsBuilder.() -> Unit):
        GetSolutionResult {
        val builder = GetSolutionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSolutionResultToKotlin(getSolutionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Target
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return A Target resource belonging to an Instance resource.
     */
    public suspend fun getTarget(argument: GetTargetPlainArgs): GetTargetResult =
        getTargetResultToKotlin(getTargetPlain(argument.toJava()).await())

    /**
     * @see [getTarget].
     * @param name Name of target.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A Target resource belonging to an Instance resource.
     */
    public suspend fun getTarget(name: String, resourceGroupName: String): GetTargetResult {
        val argument = GetTargetPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getTargetResultToKotlin(getTargetPlain(argument.toJava()).await())
    }

    /**
     * @see [getTarget].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsorchestrator&#46;kotlin&#46;inputs&#46;GetTargetPlainArgs].
     * @return A Target resource belonging to an Instance resource.
     */
    public suspend fun getTarget(argument: suspend GetTargetPlainArgsBuilder.() -> Unit):
        GetTargetResult {
        val builder = GetTargetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTargetResultToKotlin(getTargetPlain(builtArgument.toJava()).await())
    }
}
