@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin

import com.pulumi.azurenative.iotoperationsorchestrator.SolutionArgs.builder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ComponentPropertiesArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ComponentPropertiesArgsBuilder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Solution resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Solutions_CreateOrUpdate - generated by [MaximumSet] rule - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solution = new AzureNative.IoTOperationsOrchestrator.Solution("solution", new()
 *     {
 *         Components = new[]
 *         {
 *             new AzureNative.IoTOperationsOrchestrator.Inputs.ComponentPropertiesArgs
 *             {
 *                 Dependencies = new[]
 *                 {
 *                     "x",
 *                 },
 *                 Name = "yhnelpxsobdyurwvhkq",
 *                 Properties = null,
 *                 Type = "wiabwsfqhhxru",
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.IoTOperationsOrchestrator.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "bjjhfqsplgzdlbdlddleetyg",
 *             Type = "sosibrbmmrfbbyp",
 *         },
 *         Location = "svzwmojzvarczmvgfhjk",
 *         Name = "49-gj2-mwgt--1m611----35u",
 *         ResourceGroupName = "rgopenapi",
 *         Tags = null,
 *         Version = "jwxk",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsorchestrator/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsorchestrator.NewSolution(ctx, "solution", &iotoperationsorchestrator.SolutionArgs{
 * 			Components: []iotoperationsorchestrator.ComponentPropertiesArgs{
 * 				{
 * 					Dependencies: pulumi.StringArray{
 * 						pulumi.String("x"),
 * 					},
 * 					Name:       pulumi.String("yhnelpxsobdyurwvhkq"),
 * 					Properties: nil,
 * 					Type:       pulumi.String("wiabwsfqhhxru"),
 * 				},
 * 			},
 * 			ExtendedLocation: &iotoperationsorchestrator.ExtendedLocationArgs{
 * 				Name: pulumi.String("bjjhfqsplgzdlbdlddleetyg"),
 * 				Type: pulumi.String("sosibrbmmrfbbyp"),
 * 			},
 * 			Location:          pulumi.String("svzwmojzvarczmvgfhjk"),
 * 			Name:              pulumi.String("49-gj2-mwgt--1m611----35u"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Tags:              nil,
 * 			Version:           pulumi.String("jwxk"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsorchestrator.Solution;
 * import com.pulumi.azurenative.iotoperationsorchestrator.SolutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solution = new Solution("solution", SolutionArgs.builder()
 *             .components(Map.ofEntries(
 *                 Map.entry("dependencies", "x"),
 *                 Map.entry("name", "yhnelpxsobdyurwvhkq"),
 *                 Map.entry("properties", ),
 *                 Map.entry("type", "wiabwsfqhhxru")
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "bjjhfqsplgzdlbdlddleetyg"),
 *                 Map.entry("type", "sosibrbmmrfbbyp")
 *             ))
 *             .location("svzwmojzvarczmvgfhjk")
 *             .name("49-gj2-mwgt--1m611----35u")
 *             .resourceGroupName("rgopenapi")
 *             .tags()
 *             .version("jwxk")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsorchestrator:Solution l /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsOrchestrator/solutions/{name}
 * ```
 * @property components A list of components
 * @property extendedLocation Edge location of the resource.
 * @property location The geo-location where the resource lives
 * @property name Name of solution.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property version Version of the particular resource.
 */
public data class SolutionArgs(
    public val components: Output<List<ComponentPropertiesArgs>>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsorchestrator.SolutionArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsorchestrator.SolutionArgs =
        com.pulumi.azurenative.iotoperationsorchestrator.SolutionArgs.builder()
            .components(
                components?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SolutionArgs].
 */
@PulumiTagMarker
public class SolutionArgsBuilder internal constructor() {
    private var components: Output<List<ComponentPropertiesArgs>>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value A list of components
     */
    @JvmName("frcnndwoagvmhvpy")
    public suspend fun components(`value`: Output<List<ComponentPropertiesArgs>>) {
        this.components = value
    }

    @JvmName("rwpuhhvntwksbhxv")
    public suspend fun components(vararg values: Output<ComponentPropertiesArgs>) {
        this.components = Output.all(values.asList())
    }

    /**
     * @param values A list of components
     */
    @JvmName("lwtupxujttmcermp")
    public suspend fun components(values: List<Output<ComponentPropertiesArgs>>) {
        this.components = Output.all(values)
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("vqnbwgvgxuxwdudv")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kbqljucpodfuocla")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of solution.
     */
    @JvmName("wulptfgptyvbjsfk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("puyhpdljylmkcsoy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mifmkohtrgceenal")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Version of the particular resource.
     */
    @JvmName("gqhevhjcxbkocwva")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value A list of components
     */
    @JvmName("neiidnxkbuqhpcca")
    public suspend fun components(`value`: List<ComponentPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param argument A list of components
     */
    @JvmName("hujcsqhblgsuhqis")
    public suspend fun components(argument: List<suspend ComponentPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ComponentPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument A list of components
     */
    @JvmName("falnililculttgyt")
    public suspend fun components(
        vararg
        argument: suspend ComponentPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ComponentPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument A list of components
     */
    @JvmName("qrdbtpotpuotdbwi")
    public suspend fun components(argument: suspend ComponentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ComponentPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param values A list of components
     */
    @JvmName("xpbletuhuswbtddj")
    public suspend fun components(vararg values: ComponentPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("knsyvtwjuvtwwfgv")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Edge location of the resource.
     */
    @JvmName("pwoiwyfklfaanshk")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("agibgakmqsmmigtp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of solution.
     */
    @JvmName("unrwblsrouvabbnt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ibnusteosahrvqby")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mkhycupucorhugyk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jykrquyugckisdxa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Version of the particular resource.
     */
    @JvmName("kndheakxnsdnfsjo")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): SolutionArgs = SolutionArgs(
        components = components,
        extendedLocation = extendedLocation,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
        version = version,
    )
}
