@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin

import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ComponentPropertiesResponse
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ReconciliationPolicyResponse
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.TopologiesPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ComponentPropertiesResponse.Companion.toKotlin as componentPropertiesResponseToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.ReconciliationPolicyResponse.Companion.toKotlin as reconciliationPolicyResponseToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs.TopologiesPropertiesResponse.Companion.toKotlin as topologiesPropertiesResponseToKotlin

/**
 * Builder for [Target].
 */
@PulumiTagMarker
public class TargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TargetArgs = TargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TargetArgsBuilder.() -> Unit) {
        val builder = TargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Target {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsorchestrator.Target(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Target(builtJavaResource)
    }
}

/**
 * A Target resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Targets_CreateOrUpdate - generated by [MaximumSet] rule - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var target = new AzureNative.IoTOperationsOrchestrator.Target("target", new()
 *     {
 *         Components = new[]
 *         {
 *             new AzureNative.IoTOperationsOrchestrator.Inputs.ComponentPropertiesArgs
 *             {
 *                 Dependencies = new[]
 *                 {
 *                     "x",
 *                 },
 *                 Name = "yhnelpxsobdyurwvhkq",
 *                 Properties = null,
 *                 Type = "wiabwsfqhhxru",
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.IoTOperationsOrchestrator.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "bjjhfqsplgzdlbdlddleetyg",
 *             Type = "sosibrbmmrfbbyp",
 *         },
 *         Location = "pjjkifnrwvzcyohz",
 *         Name = "7---s--1-hl-fl-3f0-wfy34e08-4",
 *         ReconciliationPolicy = new AzureNative.IoTOperationsOrchestrator.Inputs.ReconciliationPolicyArgs
 *         {
 *             Interval = "wyrrzydmfgzymvzbppscxyfobku",
 *             Type = "periodic",
 *         },
 *         ResourceGroupName = "rgopenapi",
 *         Scope = "lm",
 *         Tags = null,
 *         Topologies = new[]
 *         {
 *             new AzureNative.IoTOperationsOrchestrator.Inputs.TopologiesPropertiesArgs
 *             {
 *                 Bindings = new[]
 *                 {
 *                     new AzureNative.IoTOperationsOrchestrator.Inputs.BindingPropertiesArgs
 *                     {
 *                         Config = null,
 *                         Provider = "qpwesjlyyggcbehwigbobqum",
 *                         Role = "role",
 *                     },
 *                 },
 *             },
 *         },
 *         Version = "prbigsnjltnzqliu",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsorchestrator/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsorchestrator.NewTarget(ctx, "target", &iotoperationsorchestrator.TargetArgs{
 * 			Components: []iotoperationsorchestrator.ComponentPropertiesArgs{
 * 				{
 * 					Dependencies: pulumi.StringArray{
 * 						pulumi.String("x"),
 * 					},
 * 					Name:       pulumi.String("yhnelpxsobdyurwvhkq"),
 * 					Properties: nil,
 * 					Type:       pulumi.String("wiabwsfqhhxru"),
 * 				},
 * 			},
 * 			ExtendedLocation: &iotoperationsorchestrator.ExtendedLocationArgs{
 * 				Name: pulumi.String("bjjhfqsplgzdlbdlddleetyg"),
 * 				Type: pulumi.String("sosibrbmmrfbbyp"),
 * 			},
 * 			Location: pulumi.String("pjjkifnrwvzcyohz"),
 * 			Name:     pulumi.String("7---s--1-hl-fl-3f0-wfy34e08-4"),
 * 			ReconciliationPolicy: &iotoperationsorchestrator.ReconciliationPolicyArgs{
 * 				Interval: pulumi.String("wyrrzydmfgzymvzbppscxyfobku"),
 * 				Type:     pulumi.String("periodic"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Scope:             pulumi.String("lm"),
 * 			Tags:              nil,
 * 			Topologies: []iotoperationsorchestrator.TopologiesPropertiesArgs{
 * 				{
 * 					Bindings: iotoperationsorchestrator.BindingPropertiesArray{
 * 						{
 * 							Config:   nil,
 * 							Provider: pulumi.String("qpwesjlyyggcbehwigbobqum"),
 * 							Role:     pulumi.String("role"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Version: pulumi.String("prbigsnjltnzqliu"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsorchestrator.Target;
 * import com.pulumi.azurenative.iotoperationsorchestrator.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var target = new Target("target", TargetArgs.builder()
 *             .components(Map.ofEntries(
 *                 Map.entry("dependencies", "x"),
 *                 Map.entry("name", "yhnelpxsobdyurwvhkq"),
 *                 Map.entry("properties", ),
 *                 Map.entry("type", "wiabwsfqhhxru")
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "bjjhfqsplgzdlbdlddleetyg"),
 *                 Map.entry("type", "sosibrbmmrfbbyp")
 *             ))
 *             .location("pjjkifnrwvzcyohz")
 *             .name("7---s--1-hl-fl-3f0-wfy34e08-4")
 *             .reconciliationPolicy(Map.ofEntries(
 *                 Map.entry("interval", "wyrrzydmfgzymvzbppscxyfobku"),
 *                 Map.entry("type", "periodic")
 *             ))
 *             .resourceGroupName("rgopenapi")
 *             .scope("lm")
 *             .tags()
 *             .topologies(Map.of("bindings", Map.ofEntries(
 *                 Map.entry("config", ),
 *                 Map.entry("provider", "qpwesjlyyggcbehwigbobqum"),
 *                 Map.entry("role", "role")
 *             )))
 *             .version("prbigsnjltnzqliu")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsorchestrator:Target lrhoqxofrfoihqxmmxadhxeqzsnepc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsOrchestrator/targets/{name}
 * ```
 */
public class Target internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsorchestrator.Target,
) : KotlinCustomResource(javaResource, TargetMapper) {
    /**
     * A list of components.
     */
    public val components: Output<List<ComponentPropertiesResponse>>?
        get() = javaResource.components().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> componentPropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Edge location of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Reconciliation Policy.
     */
    public val reconciliationPolicy: Output<ReconciliationPolicyResponse>?
        get() = javaResource.reconciliationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> reconciliationPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Deployment scope (such as Kubernetes namespace).
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Defines the device topology for a target or instance.
     */
    public val topologies: Output<List<TopologiesPropertiesResponse>>?
        get() = javaResource.topologies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> topologiesPropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the particular resource.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object TargetMapper : ResourceMapper<Target> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsorchestrator.Target::class == javaResource::class

    override fun map(javaResource: Resource): Target = Target(
        javaResource as
            com.pulumi.azurenative.iotoperationsorchestrator.Target,
    )
}

/**
 * @see [Target].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Target].
 */
public suspend fun target(name: String, block: suspend TargetResourceBuilder.() -> Unit): Target {
    val builder = TargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Target].
 * @param name The _unique_ name of the resulting resource.
 */
public fun target(name: String): Target {
    val builder = TargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
