@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs

import com.pulumi.azurenative.iotoperationsorchestrator.inputs.BindingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines a component binding for a provider.
 * @property config Configuration values for the binding.
 * @property provider Name of the provider.
 * @property role Role that the provider binds to with the component.
 */
public data class BindingPropertiesArgs(
    public val config: Output<Any>,
    public val provider: Output<String>,
    public val role: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsorchestrator.inputs.BindingPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.BindingPropertiesArgs =
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.BindingPropertiesArgs.builder()
            .config(config.applyValue({ args0 -> args0 }))
            .provider(provider.applyValue({ args0 -> args0 }))
            .role(role.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BindingPropertiesArgs].
 */
@PulumiTagMarker
public class BindingPropertiesArgsBuilder internal constructor() {
    private var config: Output<Any>? = null

    private var provider: Output<String>? = null

    private var role: Output<String>? = null

    /**
     * @param value Configuration values for the binding.
     */
    @JvmName("opbkghgwkvfyogdi")
    public suspend fun config(`value`: Output<Any>) {
        this.config = value
    }

    /**
     * @param value Name of the provider.
     */
    @JvmName("cmkeuakjuarxrhwi")
    public suspend fun provider(`value`: Output<String>) {
        this.provider = value
    }

    /**
     * @param value Role that the provider binds to with the component.
     */
    @JvmName("oulqdbhffovirlei")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value Configuration values for the binding.
     */
    @JvmName("bkpmcxxyqkxcmwxn")
    public suspend fun config(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value Name of the provider.
     */
    @JvmName("smvaejtipeoiegtd")
    public suspend fun provider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value Role that the provider binds to with the component.
     */
    @JvmName("tcwbuwmkhkbyilyb")
    public suspend fun role(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    internal fun build(): BindingPropertiesArgs = BindingPropertiesArgs(
        config = config ?: throw PulumiNullFieldException("config"),
        provider = provider ?: throw PulumiNullFieldException("provider"),
        role = role ?: throw PulumiNullFieldException("role"),
    )
}
